/*
 * Decompiled with CFR 0.152.
 */
package de.grobmeier.postmark;

import com.google.gson.annotations.SerializedName;
import de.grobmeier.postmark.NameValuePair;
import de.grobmeier.postmark.PostmarkMessageBase;
import de.grobmeier.postmark.SkipMe;
import java.util.List;

public class PostmarkMessage
extends PostmarkMessageBase {
    @SerializedName(value="Subject")
    private String subject;
    @SerializedName(value="HtmlBody")
    private String htmlBody;
    @SerializedName(value="TextBody")
    private String textBody;
    @SkipMe
    private boolean isHTML;

    public PostmarkMessage(String fromAddress, String toAddress, String replyToAddress, String ccAddress, String bccAddress, String subject, String body, boolean isHTML, String tag, List<NameValuePair> headers) {
        super(fromAddress, toAddress, replyToAddress, ccAddress, bccAddress, tag, headers);
        this.isHTML = isHTML;
        this.subject = subject;
        if (isHTML) {
            this.htmlBody = body;
        } else {
            this.textBody = body;
        }
    }

    public PostmarkMessage(String fromAddress, String toAddress, String replyToAddress, String ccAddress, String subject, String body, boolean isHTML, String tag, List<NameValuePair> headers) {
        this(fromAddress, toAddress, replyToAddress, ccAddress, null, subject, body, isHTML, tag, headers);
    }

    public PostmarkMessage(String fromAddress, String toAddress, String replyToAddress, String ccAddress, String subject, String body, boolean isHTML, String tag) {
        this(fromAddress, toAddress, replyToAddress, ccAddress, null, subject, body, isHTML, tag, null);
    }

    public PostmarkMessage(PostmarkMessage message) {
        super(message);
        this.isHTML = message.isHTML;
        this.subject = message.subject;
        this.htmlBody = message.htmlBody;
        this.textBody = message.textBody;
    }

    @Override
    public void clean() {
        super.clean();
        this.subject = this.subject == null ? "" : this.subject.trim();
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getHtmlBody() {
        return this.htmlBody;
    }

    public void setHtmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
    }

    public String getTextBody() {
        return this.textBody;
    }

    public void setTextBody(String textBody) {
        this.textBody = textBody;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostmarkMessage that = (PostmarkMessage)o;
        if (this.ccAddress != null ? !this.ccAddress.equals(that.ccAddress) : that.ccAddress != null) {
            return false;
        }
        if (this.bccAddress != null ? !this.bccAddress.equals(that.bccAddress) : that.bccAddress != null) {
            return false;
        }
        if (this.fromAddress != null ? !this.fromAddress.equals(that.fromAddress) : that.fromAddress != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) {
            return false;
        }
        if (this.htmlBody != null ? !this.htmlBody.equals(that.htmlBody) : that.htmlBody != null) {
            return false;
        }
        if (this.replyToAddress != null ? !this.replyToAddress.equals(that.replyToAddress) : that.replyToAddress != null) {
            return false;
        }
        if (this.subject != null ? !this.subject.equals(that.subject) : that.subject != null) {
            return false;
        }
        if (this.textBody != null ? !this.textBody.equals(that.textBody) : that.textBody != null) {
            return false;
        }
        if (this.toAddress != null ? !this.toAddress.equals(that.toAddress) : that.toAddress != null) {
            return false;
        }
        if (this.tag != null ? !this.tag.equals(that.toAddress) : that.tag != null) {
            return false;
        }
        return this.isHTML == that.isHTML;
    }

    public int hashCode() {
        int result = this.fromAddress != null ? this.fromAddress.hashCode() : 0;
        result = 31 * result + (this.toAddress != null ? this.toAddress.hashCode() : 0);
        result = 31 * result + (this.ccAddress != null ? this.ccAddress.hashCode() : 0);
        result = 31 * result + (this.bccAddress != null ? this.bccAddress.hashCode() : 0);
        result = 31 * result + (this.replyToAddress != null ? this.replyToAddress.hashCode() : 0);
        result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
        result = 31 * result + (this.htmlBody != null ? this.htmlBody.hashCode() : 0);
        result = 31 * result + (this.textBody != null ? this.textBody.hashCode() : 0);
        result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PostmarkMessage");
        sb.append("{ fromAddress='").append(this.fromAddress).append('\'');
        sb.append(", toAddress='").append(this.toAddress).append('\'');
        sb.append(", ccAddress='").append(this.ccAddress).append('\'');
        sb.append(", bccAddress='").append(this.bccAddress).append('\'');
        sb.append(", replyToAddress='").append(this.replyToAddress).append('\'');
        sb.append(", subject='").append(this.subject).append('\'');
        sb.append(", htmlBody='").append(this.htmlBody).append('\'');
        sb.append(", textBody='").append(this.textBody).append('\'');
        sb.append(", tag='").append(this.tag).append('\'');
        sb.append(", headers=").append(this.headers);
        sb.append('}');
        return sb.toString();
    }
}

