/*
 * Decompiled with CFR 0.152.
 */
package de.grobmeier.postmark;

import com.google.gson.annotations.SerializedName;
import de.grobmeier.postmark.Attachment;
import de.grobmeier.postmark.NameValuePair;
import de.grobmeier.postmark.PostmarkException;
import java.util.ArrayList;
import java.util.List;

public class PostmarkMessageBase {
    @SerializedName(value="From")
    protected String fromAddress;
    @SerializedName(value="To")
    protected String toAddress;
    @SerializedName(value="ReplyTo")
    protected String replyToAddress;
    @SerializedName(value="Cc")
    protected String ccAddress;
    @SerializedName(value="Bcc")
    protected String bccAddress;
    @SerializedName(value="Tag")
    protected String tag;
    @SerializedName(value="Headers")
    protected List<NameValuePair> headers;
    @SerializedName(value="Attachments")
    protected List<Attachment> attachments;

    protected PostmarkMessageBase(String fromAddress, String toAddress, String replyToAddress, String ccAddress, String bccAddress, String tag, List<NameValuePair> headers) {
        this.fromAddress = fromAddress;
        this.toAddress = toAddress;
        this.replyToAddress = replyToAddress;
        this.ccAddress = ccAddress;
        this.bccAddress = bccAddress;
        this.tag = tag;
        this.headers = headers == null ? new ArrayList() : headers;
    }

    protected PostmarkMessageBase(String fromAddress, String toAddress, String replyToAddress, String ccAddress, String tag, List<NameValuePair> headers) {
        this(fromAddress, toAddress, replyToAddress, ccAddress, null, tag, headers);
    }

    protected PostmarkMessageBase(String fromAddress, String toAddress, String replyToAddress, String ccAddress, String tag) {
        this(fromAddress, toAddress, replyToAddress, ccAddress, null, tag, null);
    }

    public PostmarkMessageBase(PostmarkMessageBase message) {
        this.fromAddress = message.fromAddress;
        this.toAddress = message.toAddress;
        this.replyToAddress = message.replyToAddress;
        this.ccAddress = message.ccAddress;
        this.bccAddress = message.bccAddress;
        this.headers = message.headers;
    }

    public void clean() {
        this.fromAddress = this.fromAddress.trim();
        this.toAddress = this.toAddress.trim();
    }

    public void validate() throws PostmarkException {
        if (this.fromAddress == null || this.fromAddress.equals("")) {
            throw new PostmarkException("You must specify a valid 'From' email address.");
        }
        if (this.toAddress == null || this.toAddress.equals("")) {
            throw new PostmarkException("You must specify a valid 'To' email address.");
        }
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public String getCcAddress() {
        return this.ccAddress;
    }

    public void setCcAddress(String ccAddress) {
        this.ccAddress = ccAddress;
    }

    public String getBccAddress() {
        return this.bccAddress;
    }

    public void setBccAddress(String bccAddress) {
        this.bccAddress = bccAddress;
    }

    public String getReplyToAddress() {
        return this.replyToAddress;
    }

    public void setReplyToAddress(String replyToAddress) {
        this.replyToAddress = replyToAddress;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public List<NameValuePair> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<NameValuePair> headers) {
        this.headers = headers;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public void addAttachment(Attachment attachment) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(attachment);
    }
}

