/*
 * Decompiled with CFR 0.152.
 */
package org.geojson.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.geojson.LngLatAlt;

public class LngLatAltDeserializer
extends JsonDeserializer<LngLatAlt> {
    public LngLatAlt deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.isExpectedStartArrayToken()) {
            return this.deserializeArray(jp, ctxt);
        }
        throw ctxt.mappingException(LngLatAlt.class);
    }

    protected LngLatAlt deserializeArray(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        LngLatAlt node = new LngLatAlt();
        node.setLongitude(this.extractDouble(jp, ctxt, false));
        node.setLatitude(this.extractDouble(jp, ctxt, false));
        node.setAltitude(this.extractDouble(jp, ctxt, true));
        if (jp.hasCurrentToken() && jp.getCurrentToken() != JsonToken.END_ARRAY) {
            jp.nextToken();
        }
        return node;
    }

    private double extractDouble(JsonParser jp, DeserializationContext ctxt, boolean optional) throws JsonParseException, IOException {
        JsonToken token = jp.nextToken();
        if (token == null) {
            if (optional) {
                return Double.NaN;
            }
            throw ctxt.mappingException("Unexpected end-of-input when binding data into LngLatAlt");
        }
        switch (token) {
            case END_ARRAY: {
                if (optional) {
                    return Double.NaN;
                }
                throw ctxt.mappingException("Unexpected end-of-input when binding data into LngLatAlt");
            }
            case VALUE_NUMBER_FLOAT: {
                return jp.getDoubleValue();
            }
            case VALUE_NUMBER_INT: {
                return jp.getLongValue();
            }
        }
        throw ctxt.mappingException("Unexpected token (" + token.name() + ") when binding data into LngLatAlt ");
    }
}

