/*
 * Decompiled with CFR 0.152.
 */
package org.geojson;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import org.geojson.jackson.LngLatAltDeserializer;
import org.geojson.jackson.LngLatAltSerializer;

@JsonDeserialize(using=LngLatAltDeserializer.class)
@JsonSerialize(using=LngLatAltSerializer.class)
public class LngLatAlt
implements Serializable {
    private double longitude;
    private double latitude;
    private double altitude = Double.NaN;

    public LngLatAlt() {
    }

    public LngLatAlt(double longitude, double latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public LngLatAlt(double longitude, double latitude, double altitude) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.altitude = altitude;
    }

    public boolean hasAltitude() {
        return !Double.isNaN(this.altitude);
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LngLatAlt)) {
            return false;
        }
        LngLatAlt lngLatAlt = (LngLatAlt)o;
        return Double.compare(lngLatAlt.latitude, this.latitude) == 0 && Double.compare(lngLatAlt.longitude, this.longitude) == 0 && Double.compare(lngLatAlt.altitude, this.altitude) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.longitude);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.altitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "LngLatAlt{longitude=" + this.longitude + ", latitude=" + this.latitude + ", altitude=" + this.altitude + '}';
    }
}

