/*
 * Decompiled with CFR 0.152.
 */
package org.geojson.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.geojson.LngLatAlt;

public class LngLatAltSerializer
extends JsonSerializer<LngLatAlt> {
    public static final long[] POW10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L};

    protected static String fastDoubleToString(double val, int precision) {
        StringBuilder sb = new StringBuilder();
        if (val < 0.0) {
            sb.append('-');
            val = -val;
        }
        long exp = POW10[precision];
        long lval = (long)(val * (double)exp + 0.5);
        sb.append(lval / exp).append('.');
        long fval = lval % exp;
        for (int p = precision - 1; p > 0 && fval < POW10[p] && fval > 0L; --p) {
            sb.append('0');
        }
        sb.append(fval);
        int i = sb.length() - 1;
        while (sb.charAt(i) == '0' && sb.charAt(i - 1) != '.') {
            sb.deleteCharAt(i);
            --i;
        }
        return sb.toString();
    }

    public void serialize(LngLatAlt value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartArray();
        jgen.writeNumber(LngLatAltSerializer.fastDoubleToString(value.getLongitude(), 9));
        jgen.writeNumber(LngLatAltSerializer.fastDoubleToString(value.getLatitude(), 9));
        if (value.hasAltitude()) {
            jgen.writeNumber(value.getAltitude());
        }
        jgen.writeEndArray();
    }
}

