/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.util.io.FileUtilities;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.Duration;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger log = Logger.getLogger(DefaultUncaughtExceptionHandler.class.getName());
    private volatile boolean exitOnException;
    private volatile boolean dumpThreads;

    public DefaultUncaughtExceptionHandler(boolean exitOnException) {
        this(exitOnException, false);
    }

    public DefaultUncaughtExceptionHandler(boolean exitOnException, boolean dumpThreads) {
        this.exitOnException = exitOnException;
        this.dumpThreads = dumpThreads;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        try (PrintStream stream = new PrintStream("crash.txt");){
            stream.print(String.valueOf(new Date()) + " ");
            stream.println(t.getName() + " threw an exception:");
            e.printStackTrace(stream);
            stream.println("\n" + DefaultUncaughtExceptionHandler.getSystemInfo());
            if (this.dumpsThreads()) {
                stream.println();
                stream.println(DefaultUncaughtExceptionHandler.dump());
            }
        }
        catch (FileNotFoundException e2) {
            log.log(Level.WARNING, "Could not create crash report file.", e);
        }
        log.log(Level.SEVERE, "Game crashed! :(", e);
        if (this.exitOnException() || e instanceof Error) {
            System.exit(-1);
        }
    }

    public boolean exitOnException() {
        return this.exitOnException;
    }

    public boolean dumpsThreads() {
        return this.dumpThreads;
    }

    public void setExitOnException(boolean exit) {
        this.exitOnException = exit;
    }

    public void dumpThreads(boolean dumpThreads) {
        this.dumpThreads = dumpThreads;
    }

    protected static String dump() {
        StringBuilder text = new StringBuilder();
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        ThreadInfo[] dumps = threads.getThreadInfo(threads.getAllThreadIds(), 255);
        text.append("====THREAD DUMP====\n\n");
        for (ThreadInfo dump : dumps) {
            StackTraceElement[] elements;
            text.append("\"").append(dump.getThreadName()).append("\"\n");
            Thread.State state = dump.getThreadState();
            text.append("\tState: ").append((Object)state);
            String blockedBy = dump.getLockOwnerName();
            if (blockedBy != null) {
                text.append(" on ").append(blockedBy);
            }
            text.append("\n");
            for (StackTraceElement element : elements = dump.getStackTrace()) {
                text.append("\t\tat ");
                text.append(element);
                text.append("\n");
            }
            text.append("\n\n");
        }
        return text.toString();
    }

    protected static String getSystemInfo() {
        StringBuilder text = new StringBuilder();
        text.append("====Runtime Information====\n");
        text.append("Operating System: ").append(System.getProperty("os.name")).append("\n");
        text.append("\tArchitecture: ").append(System.getProperty("os.arch")).append("\n");
        text.append("\tVersion: ").append(System.getProperty("os.version")).append("\n");
        text.append("Memory:\n");
        long heapSize = Runtime.getRuntime().totalMemory();
        long maxHeapSize = Runtime.getRuntime().maxMemory();
        long freeHeapSize = Runtime.getRuntime().freeMemory();
        text.append("\tMax heap size: ").append(FileUtilities.humanReadableByteCount(maxHeapSize)).append("\n");
        text.append("\tCurrent heap size: ").append(FileUtilities.humanReadableByteCount(heapSize)).append("\n");
        text.append("\tHeap used: ").append(FileUtilities.humanReadableByteCount(heapSize - freeHeapSize)).append("\n");
        text.append("\tFree heap: ").append(FileUtilities.humanReadableByteCount(freeHeapSize)).append("\n");
        text.append("Java Version: ").append(System.getProperty("java.runtime.name")).append(" ").append(System.getProperty("java.runtime.version")).append(" \n");
        text.append("\tVendor: ").append(System.getProperty("java.vm.vendor")).append("\n");
        text.append("Uptime: ").append(Duration.ofMillis(ManagementFactory.getRuntimeMXBean().getUptime())).append("\n");
        GraphicsEnvironment g = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = g.getScreenDevices();
        text.append("Screens: ").append(screens.length).append("\n");
        for (int i = 0; i < screens.length; ++i) {
            GraphicsDevice screen = screens[i];
            DisplayMode displayMode = screen.getDisplayMode();
            text.append("\tScreen ").append(i).append(": ").append(displayMode.getWidth()).append("x").append(displayMode.getHeight());
            if (displayMode.getRefreshRate() != 0) {
                text.append("@").append(displayMode.getRefreshRate()).append("hz");
            }
            text.append("\n");
        }
        return text.toString();
    }
}

