/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;

public enum Direction {
    DOWN(1, 360.0f),
    LEFT(2, 270.0f),
    RIGHT(4, 90.0f),
    UNDEFINED(8, 0.0f),
    UP(16, 180.0f);

    private final byte flagValue;
    private final float angle;

    private Direction(byte flagValue, float angle) {
        this.flagValue = flagValue;
        this.angle = angle;
    }

    public static Direction fromAngle(double angle) {
        double actual = GeometricUtilities.normalizeAngle(angle);
        if (actual >= 0.0 && actual < 45.0) {
            return DOWN;
        }
        if (actual >= 45.0 && actual < 135.0) {
            return RIGHT;
        }
        if (actual >= 135.0 && actual < 225.0) {
            return UP;
        }
        if (actual >= 225.0 && actual < 315.0) {
            return LEFT;
        }
        if (actual >= 315.0 && actual <= 360.0) {
            return DOWN;
        }
        return UNDEFINED;
    }

    public static Direction fromFlagValue(byte flagValue) {
        for (Direction dir : Direction.values()) {
            if (dir.toFlagValue() != flagValue) continue;
            return dir;
        }
        return UNDEFINED;
    }

    public Direction getOpposite() {
        switch (this.ordinal()) {
            case 2: {
                return LEFT;
            }
            case 4: {
                return DOWN;
            }
            case 1: {
                return RIGHT;
            }
            case 0: {
                return UP;
            }
        }
        return this;
    }

    public float toAngle() {
        return this.angle;
    }

    public byte toFlagValue() {
        return this.flagValue;
    }
}

