/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.abilities.Ability;
import de.gurkenlabs.litiengine.abilities.effects.Effect;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AbilityExecution
implements IUpdateable {
    private final Ability ability;
    private final List<Effect> appliedEffects = new CopyOnWriteArrayList<Effect>();
    private final Point2D castLocation;
    private final long executionTicks;
    private final Shape impactArea;

    AbilityExecution(Ability ability) {
        this.ability = ability;
        this.executionTicks = Game.time().now();
        this.impactArea = ability.calculateImpactArea();
        this.castLocation = ability.getExecutor().getCenter();
        Game.loop().attach(this);
    }

    public Ability getAbility() {
        return this.ability;
    }

    public List<Effect> getAppliedEffects() {
        return this.appliedEffects;
    }

    public Point2D getCastLocation() {
        return this.castLocation;
    }

    public Shape getExecutionImpactArea() {
        return this.impactArea;
    }

    public long getExecutionTicks() {
        return this.executionTicks;
    }

    @Override
    public void update() {
        if (this.getAbility().getEffects().isEmpty() || this.getAbility().getEffects().size() == this.getAppliedEffects().size()) {
            Game.loop().detach(this);
            return;
        }
        this.applyAbilityEffects();
    }

    private void applyAbilityEffects() {
        long gameTicksSinceExecution = Game.time().since(this.getExecutionTicks());
        this.getAbility().getEffects().stream().filter(effect -> !this.getAppliedEffects().contains(effect) && gameTicksSinceExecution >= (long)effect.getDelay()).forEach(effect -> {
            effect.apply(this.getExecutionImpactArea());
            this.getAppliedEffects().add((Effect)effect);
        });
    }
}

