/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities.effects;

import de.gurkenlabs.litiengine.abilities.effects.Effect;
import de.gurkenlabs.litiengine.abilities.effects.EffectApplication;
import de.gurkenlabs.litiengine.abilities.targeting.TargetingStrategy;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.physics.Force;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ForceEffect
extends Effect {
    private final float strength;
    private final Map<IMobileEntity, Force> appliedForces;

    protected ForceEffect(TargetingStrategy targetingStrategy, float strength) {
        this(targetingStrategy, null, strength);
    }

    protected ForceEffect(TargetingStrategy targetingStrategy, ICombatEntity executingEntity, float strength) {
        super(targetingStrategy, executingEntity);
        this.strength = strength;
        this.appliedForces = new ConcurrentHashMap<IMobileEntity, Force>();
    }

    @Override
    public void apply(ICombatEntity affectedEntity) {
        super.apply(affectedEntity);
        if (affectedEntity instanceof IMobileEntity) {
            IMobileEntity mobileEntity = (IMobileEntity)((Object)affectedEntity);
            Force force = this.createForce(mobileEntity);
            this.appliedForces.put(mobileEntity, force);
            mobileEntity.movement().apply(force);
        }
    }

    public float getStrength() {
        return this.strength;
    }

    protected abstract Force createForce(IMobileEntity var1);

    @Override
    public void cease(ICombatEntity entity) {
        IMobileEntity mobileEntity;
        super.cease(entity);
        if (entity instanceof IMobileEntity && this.appliedForces.containsKey(mobileEntity = (IMobileEntity)((Object)entity))) {
            this.appliedForces.get(mobileEntity).end();
            this.appliedForces.remove(mobileEntity);
        }
    }

    @Override
    protected boolean hasEnded(EffectApplication appliance) {
        return super.hasEnded(appliance) || this.appliedForces.isEmpty() || this.appliedForces.values().stream().allMatch(Force::hasEnded);
    }
}

