/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities.effects;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.abilities.effects.Effect;
import de.gurkenlabs.litiengine.abilities.targeting.TargetingStrategy;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.sound.Sound;
import java.util.Arrays;

public class SoundEffect
extends Effect {
    private final Sound[] sounds;

    public SoundEffect(ICombatEntity executingEntity, Sound ... sounds) {
        super(TargetingStrategy.executingEntity(), executingEntity);
        this.sounds = sounds;
    }

    public SoundEffect(Sound ... sounds) {
        this((ICombatEntity)null, sounds);
    }

    public SoundEffect(ICombatEntity executingEntity, String ... sounds) {
        this(executingEntity, (Sound[])Arrays.stream(sounds).map(x -> (Sound)Resources.sounds().get((String)x)).toArray(Sound[]::new));
    }

    public SoundEffect(String ... sounds) {
        this((ICombatEntity)null, sounds);
    }

    @Override
    protected void apply(ICombatEntity entity) {
        super.apply(entity);
        Game.audio().playSound(Game.random().choose(this.sounds), (IEntity)entity);
    }
}

