/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.entities.CollisionEntity;
import de.gurkenlabs.litiengine.entities.CollisionInfo;
import de.gurkenlabs.litiengine.entities.EntityInfo;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.environment.tilemap.TmxType;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.physics.Collision;
import java.awt.geom.Rectangle2D;

@EntityInfo(renderType=RenderType.OVERLAY)
@CollisionInfo(collision=true, collisionType=Collision.STATIC)
@TmxType(value=MapObjectType.COLLISIONBOX)
public class CollisionBox
extends CollisionEntity {
    @TmxProperty(name="isObstructingLight")
    private boolean obstructingLight;

    public CollisionBox() {
    }

    public CollisionBox(boolean obstructingLight) {
        this.obstructingLight = obstructingLight;
    }

    public CollisionBox(double width, double height) {
        this.setWidth(width);
        this.setHeight(height);
        this.setCollisionBoxWidth(this.getWidth());
        this.setCollisionBoxHeight(this.getHeight());
    }

    public CollisionBox(double x, double y, double width, double height) {
        this(width, height);
        this.setX(x);
        this.setY(y);
    }

    public CollisionBox(Rectangle2D box) {
        this(box.getX(), box.getY(), box.getWidth(), box.getHeight());
    }

    public boolean isObstructingLight() {
        return this.obstructingLight;
    }
}

