/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Direction;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.attributes.Attribute;
import de.gurkenlabs.litiengine.entities.CombatEntity;
import de.gurkenlabs.litiengine.entities.EntityMovedEvent;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.entities.MovementInfo;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.environment.tilemap.TmxType;
import de.gurkenlabs.litiengine.graphics.animation.CreatureAnimationController;
import de.gurkenlabs.litiengine.graphics.animation.EntityAnimationController;
import de.gurkenlabs.litiengine.graphics.animation.IEntityAnimationController;
import de.gurkenlabs.litiengine.physics.IMovementController;
import de.gurkenlabs.litiengine.physics.MovementController;
import de.gurkenlabs.litiengine.tweening.TweenType;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

@MovementInfo
@TmxType(value=MapObjectType.CREATURE)
public class Creature
extends CombatEntity
implements IMobileEntity {
    private static final int IDLE_DELAY = 100;
    private final Collection<IMobileEntity.EntityMovedListener> movedListeners = ConcurrentHashMap.newKeySet();
    @TmxProperty(name="acceleration")
    private int acceleration;
    @TmxProperty(name="deceleration")
    private int deceleration;
    @TmxProperty(name="turnOnMove")
    private boolean turnOnMove;
    @TmxProperty(name="velocity")
    private Attribute<Float> velocity;
    @TmxProperty(name="spritesheetName")
    private String spritesheetName;
    @TmxProperty(name="scaling")
    private boolean scaling;
    private long lastMoved;

    public Creature() {
        this(null);
    }

    public Creature(String spritesheetName) {
        MovementInfo movementInfo = this.getClass().getAnnotation(MovementInfo.class);
        if (movementInfo != null) {
            this.velocity = new Attribute<Float>(Float.valueOf(movementInfo.velocity()));
            this.acceleration = movementInfo.acceleration();
            this.deceleration = movementInfo.deceleration();
            this.setTurnOnMove(movementInfo.turnOnMove());
            this.addController(this.createMovementController());
        }
        if (spritesheetName != null) {
            this.setSpritesheetName(spritesheetName);
        } else {
            this.setSpritesheetName(Game.random().choose(EntityAnimationController.getDefaultSpritePrefixes(this.getClass())));
        }
    }

    @Override
    public void onMoved(IMobileEntity.EntityMovedListener listener) {
        this.movedListeners.add(listener);
    }

    @Override
    public void removeMovedListener(IMobileEntity.EntityMovedListener listener) {
        this.movedListeners.remove(listener);
    }

    @Override
    public float[] getTweenValues(TweenType tweenType) {
        if (tweenType == TweenType.VELOCITY) {
            return new float[]{this.getVelocity().get().floatValue()};
        }
        return super.getTweenValues(tweenType);
    }

    @Override
    public void setTweenValues(TweenType tweenType, float[] newValues) {
        if (tweenType == TweenType.VELOCITY) {
            this.getVelocity().setBaseValue(Float.valueOf(newValues[0]));
        } else {
            super.setTweenValues(tweenType, newValues);
        }
    }

    @Override
    public int getAcceleration() {
        return this.acceleration;
    }

    @Override
    public int getDeceleration() {
        return this.deceleration;
    }

    public Direction getFacingDirection() {
        return Direction.fromAngle(this.getAngle());
    }

    @Override
    public IMovementController movement() {
        return this.getController(IMovementController.class);
    }

    public String getSpritesheetName() {
        return this.spritesheetName;
    }

    @Override
    public float getTickVelocity() {
        return (float)Math.min(Game.loop().getDeltaTime(), 67L) * 0.001f * this.getVelocity().get().floatValue() * Game.loop().getTimeScale();
    }

    @Override
    public Attribute<Float> getVelocity() {
        return this.velocity;
    }

    public boolean isScaling() {
        return this.scaling;
    }

    public boolean isIdle() {
        return Game.time().since(this.lastMoved) > 100L;
    }

    @Override
    public void setAcceleration(int acceleration) {
        this.acceleration = acceleration;
    }

    @Override
    public void setDeceleration(int deceleration) {
        this.deceleration = deceleration;
    }

    public void setFacingDirection(Direction facingDirection) {
        this.setAngle(facingDirection.toAngle());
    }

    @Override
    public void setLocation(Point2D location) {
        if (this.isDead() || location == null) {
            return;
        }
        Point2D oldLocation = this.getLocation();
        super.setLocation(location);
        if (Game.hasStarted() && this.isLoaded()) {
            this.lastMoved = Game.time().now();
            this.fireMovedEvent(new EntityMovedEvent(this, this.getX() - oldLocation.getX(), this.getY() - oldLocation.getY()));
        }
    }

    @Override
    public void setTurnOnMove(boolean turn) {
        this.turnOnMove = turn;
    }

    public void setSpritesheetName(String spritesheetName) {
        if (this.spritesheetName != null && this.spritesheetName.equals(spritesheetName)) {
            return;
        }
        this.spritesheetName = spritesheetName;
        this.updateAnimationController();
    }

    public void setScaling(boolean scaling) {
        this.scaling = scaling;
    }

    @Override
    public void setVelocity(float velocity) {
        this.getVelocity().setBaseValue(Float.valueOf(velocity));
    }

    @Override
    public boolean turnOnMove() {
        return this.turnOnMove;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("#" + this.getMapId() + ": ");
        if (this.getName() != null && !this.getName().isEmpty()) {
            sb.append(this.getName());
        } else {
            sb.append(Creature.class.getSimpleName());
        }
        sb.append(" (" + this.getSpritesheetName() + ")");
        return sb.toString();
    }

    protected void updateAnimationController() {
        IEntityAnimationController<?> controller = this.createAnimationController();
        this.getControllers().addController(controller);
        if (Game.world().environment() != null && Game.world().environment().isLoaded()) {
            Game.loop().attach(controller);
        }
    }

    protected IEntityAnimationController<?> createAnimationController() {
        return new CreatureAnimationController<Creature>(this, true);
    }

    protected IMovementController createMovementController() {
        return new MovementController<Creature>(this);
    }

    private void fireMovedEvent(EntityMovedEvent event) {
        for (IMobileEntity.EntityMovedListener listener : this.movedListeners) {
            listener.moved(event);
        }
    }
}

