/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities.behavior;

import de.gurkenlabs.litiengine.entities.behavior.StateEvent;
import de.gurkenlabs.litiengine.entities.behavior.StateListener;
import de.gurkenlabs.litiengine.entities.behavior.Transition;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class State {
    private final String name;
    private final List<Transition> transitions;
    private final Collection<StateListener> listeners = ConcurrentHashMap.newKeySet();

    protected State(String name) {
        this.transitions = new CopyOnWriteArrayList<Transition>();
        this.name = name;
    }

    public void enter() {
        StateEvent event = new StateEvent(this);
        this.listeners.forEach(listener -> listener.onEnter(event));
    }

    public void exit() {
        StateEvent event = new StateEvent(this);
        this.listeners.forEach(listener -> listener.onExit(event));
    }

    public String getName() {
        return this.name;
    }

    public List<Transition> getTransitions() {
        return this.transitions;
    }

    public void addStateListener(StateListener listener) {
        this.listeners.add(listener);
    }

    public void removeStateListener(StateListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract void perform();
}

