/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CustomMapObjectLoader
extends MapObjectLoader {
    private static final Logger log = Logger.getLogger(CustomMapObjectLoader.class.getName());
    private final ConstructorInvocation invoke;

    CustomMapObjectLoader(String mapObjectType, ConstructorInvocation invocation) {
        super(mapObjectType);
        this.invoke = invocation;
    }

    static ConstructorInvocation findConstructor(Class<? extends IEntity> entityType) {
        ConstructorInvocation inv = null;
        int priority = 0;
        for (Constructor<?> constructor : entityType.getConstructors()) {
            Class<?>[] classes = constructor.getParameterTypes();
            if (classes.length == 2) {
                if (classes[0] == Environment.class && classes[1] == IMapObject.class) {
                    return (e, o) -> (IEntity)constructor.newInstance(e, o);
                }
                if (classes[0] != IMapObject.class || classes[1] != Environment.class) continue;
                inv = (e, o) -> (IEntity)constructor.newInstance(o, e);
                priority = 3;
                continue;
            }
            if (classes.length == 1) {
                if (priority >= 3) continue;
                if (classes[0] == IMapObject.class) {
                    inv = (e, o) -> (IEntity)constructor.newInstance(o);
                    priority = 2;
                    continue;
                }
                if (priority >= 2 || classes[0] != Environment.class) continue;
                inv = (e, o) -> (IEntity)constructor.newInstance(e);
                priority = 1;
                continue;
            }
            if (classes.length != 0 || priority >= 1) continue;
            inv = (e, o) -> (IEntity)constructor.newInstance(new Object[0]);
        }
        return inv;
    }

    @Override
    public Collection<IEntity> load(Environment environment, IMapObject mapObject) {
        IEntity entity;
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        if (!this.isMatchingType(mapObject)) {
            return entities;
        }
        try {
            entity = this.invoke.invoke(environment, mapObject);
        }
        catch (ReflectiveOperationException e) {
            log.log(Level.SEVERE, "map object {} failed to load", mapObject.getId());
            return entities;
        }
        CustomMapObjectLoader.loadDefaultProperties(entity, mapObject);
        entities.add(entity);
        return entities;
    }

    @FunctionalInterface
    static interface ConstructorInvocation {
        public IEntity invoke(Environment var1, IMapObject var2) throws InvocationTargetException, IllegalAccessException, InstantiationException;
    }
}

