/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.Direction;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.Spawnpoint;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import java.util.ArrayList;
import java.util.Collection;

public class SpawnpointMapObjectLoader
extends MapObjectLoader {
    protected SpawnpointMapObjectLoader() {
        super(MapObjectType.SPAWNPOINT);
    }

    @Override
    public Collection<IEntity> load(Environment environment, IMapObject mapObject) {
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        if (!this.isMatchingType(mapObject)) {
            return entities;
        }
        Direction direction = mapObject.getEnumValue("spawnDirection", Direction.class, Direction.DOWN);
        String spawnType = mapObject.getStringValue("spawnInfo", null);
        Spawnpoint spawn = this.createSpawnpoint(mapObject, direction, spawnType);
        SpawnpointMapObjectLoader.loadDefaultProperties(spawn, mapObject);
        entities.add(spawn);
        return entities;
    }

    protected Spawnpoint createSpawnpoint(IMapObject mapObject, Direction direction, String spawnType) {
        return new Spawnpoint(direction, spawnType);
    }
}

