/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap;

import de.gurkenlabs.litiengine.environment.tilemap.ICustomPropertyProvider;
import de.gurkenlabs.litiengine.environment.tilemap.IGroupLayer;
import de.gurkenlabs.litiengine.environment.tilemap.IImageLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ILayer;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITileLayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface ILayerList
extends ICustomPropertyProvider {
    public List<ILayer> getRenderLayers();

    public List<IMapObjectLayer> getMapObjectLayers();

    public void addLayer(ILayer var1);

    public void addLayer(int var1, ILayer var2);

    public void removeLayer(ILayer var1);

    default public IMapObjectLayer getMapObjectLayer(IMapObject mapObject) {
        for (IMapObjectLayer layer : this.getMapObjectLayers()) {
            Optional<IMapObject> found = layer.getMapObjects().stream().filter(x -> x.getId() == mapObject.getId()).findFirst();
            if (!found.isPresent()) continue;
            return layer;
        }
        return null;
    }

    default public IMapObjectLayer getMapObjectLayer(String layerName) {
        Optional<IMapObjectLayer> layer = this.getMapObjectLayers().stream().filter(x -> x.getName().equals(layerName)).findFirst();
        return layer.orElse(null);
    }

    default public IMapObjectLayer getMapObjectLayer(int layerId) {
        Optional<IMapObjectLayer> layer = this.getMapObjectLayers().stream().filter(x -> x.getId() == layerId).findFirst();
        return layer.orElse(null);
    }

    public void removeLayer(int var1);

    default public Collection<IMapObject> getMapObjects() {
        ArrayList<IMapObject> mapObjects = new ArrayList<IMapObject>();
        if (this.getMapObjectLayers() == null) {
            return mapObjects;
        }
        for (IMapObjectLayer layer : this.getMapObjectLayers()) {
            if (layer == null) continue;
            for (IMapObject mapObject : layer.getMapObjects()) {
                if (mapObject == null) continue;
                mapObjects.add(mapObject);
            }
        }
        return Collections.unmodifiableCollection(mapObjects);
    }

    default public Collection<IMapObject> getMapObjects(String ... types) {
        ArrayList<IMapObject> mapObjects = new ArrayList<IMapObject>();
        if (this.getMapObjectLayers() == null || this.getMapObjectLayers().isEmpty() || types.length == 0) {
            return mapObjects;
        }
        for (IMapObjectLayer layer : this.getMapObjectLayers()) {
            if (layer == null) continue;
            mapObjects.addAll(layer.getMapObjects(types));
        }
        return mapObjects;
    }

    default public Collection<IMapObject> getMapObjects(int ... mapIDs) {
        ArrayList<IMapObject> mapObjects = new ArrayList<IMapObject>();
        if (this.getMapObjectLayers() == null || this.getMapObjectLayers().isEmpty() || mapIDs.length == 0) {
            return mapObjects;
        }
        for (IMapObjectLayer layer : this.getMapObjectLayers()) {
            if (layer == null) continue;
            mapObjects.addAll(layer.getMapObjects(mapIDs));
        }
        return mapObjects;
    }

    default public IMapObject getMapObject(int mapId) {
        if (this.getMapObjectLayers() == null) {
            return null;
        }
        for (IMapObjectLayer layer : this.getMapObjectLayers()) {
            if (layer == null) continue;
            for (IMapObject mapObject : layer.getMapObjects()) {
                if (mapObject == null || mapObject.getId() != mapId) continue;
                return mapObject;
            }
        }
        return null;
    }

    default public void removeMapObject(int mapId) {
        for (IMapObjectLayer layer : this.getMapObjectLayers()) {
            IMapObject remove = null;
            for (IMapObject obj : layer.getMapObjects()) {
                if (obj.getId() != mapId) continue;
                remove = obj;
                break;
            }
            if (remove == null) continue;
            layer.removeMapObject(remove);
            break;
        }
    }

    public List<ITileLayer> getTileLayers();

    public List<IImageLayer> getImageLayers();

    public List<IGroupLayer> getGroupLayers();
}

