/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObjectText;
import de.gurkenlabs.litiengine.environment.tilemap.IPolyShape;
import de.gurkenlabs.litiengine.environment.tilemap.ITilesetEntry;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import de.gurkenlabs.litiengine.environment.tilemap.xml.DecimalFloatAdapter;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.xml.PolyShape;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Text;
import de.gurkenlabs.litiengine.environment.tilemap.xml.TmxException;
import de.gurkenlabs.litiengine.environment.tilemap.xml.TmxMap;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.Arrays;

public class MapObject
extends CustomPropertyProvider
implements IMapObject {
    @XmlAttribute
    private int id;
    @XmlAttribute
    private Integer gid;
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String type;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=DecimalFloatAdapter.class)
    private Float x;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=DecimalFloatAdapter.class)
    private Float y;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=DecimalFloatAdapter.class)
    private Float width = Float.valueOf(0.0f);
    @XmlAttribute
    @XmlJavaTypeAdapter(value=DecimalFloatAdapter.class)
    private Float height = Float.valueOf(0.0f);
    @XmlTransient
    private ITilesetEntry tile;
    @XmlElement(name="polyline")
    private PolyShape polyline;
    @XmlElement(name="polygon")
    private PolyShape polygon;
    @XmlElement
    private String point;
    @XmlElement
    private String ellipse;
    @XmlElement
    private Text text;
    private transient MapObjectLayer layer;

    public MapObject() {
    }

    public MapObject(String type) {
        this.type = type;
    }

    public MapObject(MapObject original) {
        super(original);
        this.setName(original.getName());
        this.setId(Game.world().environment().getNextMapId());
        this.polyline = original.getPolyline() != null && !original.getPolyline().getPoints().isEmpty() ? new PolyShape(original.getPolyline()) : null;
        this.polygon = original.getPolygon() != null && !original.getPolygon().getPoints().isEmpty() ? new PolyShape(original.getPolygon()) : null;
        this.setType(original.getType());
        this.setX(original.getX());
        this.setY(original.getY());
        this.setWidth(original.getWidth());
        this.setHeight(original.getHeight());
        this.setLayer(original.layer);
        this.text = original.text;
        this.ellipse = original.ellipse;
        this.point = original.point;
    }

    public MapObject(MapObject original, boolean keepID) {
        this(original);
        if (keepID) {
            this.setId(original.getId());
        }
    }

    public MapObject(MapObject original, int id) {
        this(original);
        this.setId(id);
    }

    public static Rectangle2D getBounds(IMapObject ... objects) {
        return MapObject.getBounds(Arrays.asList(objects));
    }

    public static Rectangle2D getBounds(Iterable<IMapObject> objects) {
        double x = Double.MAX_VALUE;
        double y = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (IMapObject object : objects) {
            Rectangle2D bounds = object.getBoundingBox();
            x = Math.min(bounds.getX(), x);
            y = Math.min(bounds.getY(), y);
            maxX = Math.max(bounds.getMaxX(), maxX);
            maxY = Math.max(bounds.getMaxY(), maxY);
        }
        return new Rectangle2D.Double(x, y, maxX - x, maxY - y);
    }

    @Override
    public int getGridId() {
        if (this.gid == null) {
            return 0;
        }
        return this.gid;
    }

    @Override
    public ITilesetEntry getTile() {
        return this.tile;
    }

    @Override
    public Rectangle2D getBoundingBox() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.width.floatValue(), this.height.floatValue());
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Point2D getLocation() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public IPolyShape getPolyline() {
        return this.polyline;
    }

    @Override
    public IPolyShape getPolygon() {
        return this.polygon;
    }

    @Override
    public Ellipse2D getEllipse() {
        if (!this.isEllipse()) {
            return null;
        }
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    public IMapObjectText getText() {
        return this.text;
    }

    @Override
    @XmlTransient
    public void setGridId(int gid) {
        this.gid = gid;
    }

    @Override
    @XmlTransient
    public void setHeight(float height) {
        this.height = Float.valueOf(Math.max(height, 0.0f));
    }

    @Override
    @XmlTransient
    public void setId(int id) {
        this.id = id;
    }

    @Override
    @XmlTransient
    public void setName(String name) {
        if (name != null && name.isEmpty()) {
            this.name = null;
            return;
        }
        this.name = name;
    }

    @Override
    @XmlTransient
    public void setType(String type) {
        this.type = type;
    }

    @Override
    @XmlTransient
    public void setWidth(float width) {
        this.width = Float.valueOf(Math.max(width, 0.0f));
    }

    @Override
    @XmlTransient
    public void setX(float x) {
        if (this.isInfiniteMap()) {
            TmxMap map = (TmxMap)this.getLayer().getMap();
            this.x = Float.valueOf(x + (float)(map.getChunkOffsetX() * map.getTileWidth()));
            return;
        }
        this.x = Float.valueOf(x);
    }

    @Override
    @XmlTransient
    public void setY(float y) {
        if (this.isInfiniteMap()) {
            TmxMap map = (TmxMap)this.getLayer().getMap();
            this.y = Float.valueOf(y + (float)(map.getChunkOffsetY() * map.getTileHeight()));
            return;
        }
        this.y = Float.valueOf(y);
    }

    @Override
    public void setLocation(Point2D location) {
        if (location == null) {
            return;
        }
        this.setLocation((float)location.getX(), (float)location.getY());
    }

    @Override
    public void setLocation(float x, float y) {
        this.setX(x);
        this.setY(y);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("#" + this.getId() + ": ");
        sb.append((String)(this.getName() == null ? "" : "'" + this.getName() + "' "));
        sb.append(this.getType());
        sb.append("; x: " + this.getX());
        sb.append("; y: " + this.getY());
        sb.append("; width: " + this.getWidth());
        sb.append("; height: " + this.getHeight());
        return sb.toString();
    }

    @Override
    public float getX() {
        if (this.isInfiniteMap()) {
            TmxMap map = (TmxMap)this.getLayer().getMap();
            return this.x.floatValue() - (float)(map.getChunkOffsetX() * map.getTileWidth());
        }
        return this.x == null ? 0.0f : this.x.floatValue();
    }

    @Override
    public float getY() {
        if (this.isInfiniteMap()) {
            TmxMap map = (TmxMap)this.getLayer().getMap();
            return this.y.floatValue() - (float)(map.getChunkOffsetY() * map.getTileHeight());
        }
        return this.y == null ? 0.0f : this.y.floatValue();
    }

    @Override
    @XmlTransient
    public void setPolyline(IPolyShape polyline) {
        this.polyline = (PolyShape)polyline;
    }

    @Override
    @XmlTransient
    public void setPolygon(IPolyShape polygon) {
        this.polygon = (PolyShape)polygon;
    }

    @Override
    public float getWidth() {
        return this.width.floatValue();
    }

    @Override
    public float getHeight() {
        return this.height.floatValue();
    }

    @Override
    public IMapObjectLayer getLayer() {
        return this.layer;
    }

    @Override
    public boolean isPolyline() {
        return this.polyline != null;
    }

    @Override
    public boolean isPolygon() {
        return this.polygon != null;
    }

    @Override
    public boolean isPoint() {
        return this.point != null;
    }

    @Override
    public boolean isEllipse() {
        return this.ellipse != null;
    }

    private void afterUnmarshal(Unmarshaller u, Object parent) {
        if (parent instanceof MapObjectLayer) {
            MapObjectLayer mapObjectLayer = (MapObjectLayer)parent;
            this.setLayer(mapObjectLayer);
        }
        if (this.gid != null && this.gid == 0) {
            this.gid = null;
        }
        if (this.name != null && this.name.isEmpty()) {
            this.name = null;
        }
        if (this.polyline != null && this.polyline.getPoints().isEmpty()) {
            this.polyline = null;
        }
    }

    @Override
    void finish(URL location) throws TmxException {
        super.finish(location);
        if (this.gid != null) {
            this.tile = this.getLayer().getMap().getTilesetEntry(this.gid);
        }
    }

    protected void setLayer(MapObjectLayer layer) {
        this.layer = layer;
    }

    private boolean isInfiniteMap() {
        return this.getLayer() != null && this.getLayer().getMap() != null && this.getLayer().getMap().isInfinite() && this.getLayer().getMap() instanceof TmxMap;
    }
}

