/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.ICustomProperty;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.ITilesetEntry;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Tile
extends CustomPropertyProvider
implements ITile {
    public static final int NONE = 0;
    public static final Tile EMPTY = new Tile(0);
    protected static final int FLIPPED_HORIZONTALLY_FLAG = Integer.MIN_VALUE;
    protected static final int FLIPPED_VERTICALLY_FLAG = 0x40000000;
    protected static final int FLIPPED_DIAGONALLY_FLAG = 0x20000000;
    private static final AffineTransform TX_DIAGONAL_FLIP = new AffineTransform(0.0, 1.0, 1.0, 0.0, 0.0, 0.0);
    @XmlAttribute
    private Integer gid;
    private transient Point tileCoordinate;
    private transient ITilesetEntry tilesetEntry;
    private transient boolean flippedDiagonally;
    private transient boolean flippedHorizontally;
    private transient boolean flippedVertically;
    private transient boolean flipped;

    public Tile() {
    }

    public Tile(Tile original) {
        this.flipped = original.isFlipped();
        this.flippedDiagonally = original.isFlippedDiagonally();
        this.flippedHorizontally = original.isFlippedHorizontally();
        this.flippedVertically = original.isFlippedVertically();
        this.tilesetEntry = original.getTilesetEntry();
        this.gid = original.getGridId();
        this.tileCoordinate = original.getTileCoordinate();
    }

    public Tile(int gidBitmask) {
        this.flippedDiagonally = (gidBitmask & 0x20000000) != 0;
        this.flippedHorizontally = (gidBitmask & Integer.MIN_VALUE) != 0;
        this.flippedVertically = (gidBitmask & 0x40000000) != 0;
        this.flipped = this.isFlippedDiagonally() || this.isFlippedHorizontally() || this.isFlippedVertically();
        this.gid = gidBitmask & 0x1FFFFFFF;
    }

    @Override
    public boolean hasCustomProperty(String name) {
        return this.getTilesetEntry() == null ? super.hasCustomProperty(name) : this.getTilesetEntry().hasCustomProperty(name);
    }

    @Override
    public Map<String, ICustomProperty> getProperties() {
        return this.getTilesetEntry() == null ? Collections.emptyMap() : this.getTilesetEntry().getProperties();
    }

    @Override
    public void setProperties(Map<String, ICustomProperty> props) {
        if (this.getTilesetEntry() == null) {
            super.setProperties(props);
        } else {
            this.getTilesetEntry().setProperties(props);
        }
    }

    @Override
    public boolean isFlippedDiagonally() {
        return this.flippedDiagonally;
    }

    @Override
    public boolean isFlippedHorizontally() {
        return this.flippedHorizontally;
    }

    @Override
    public boolean isFlippedVertically() {
        return this.flippedVertically;
    }

    @Override
    public boolean isFlipped() {
        return this.flipped;
    }

    @Override
    public BufferedImage getImage() {
        if (this.tilesetEntry == null) {
            return null;
        }
        BufferedImage base = this.getTilesetEntry().getImage();
        if (!this.isFlipped()) {
            return base;
        }
        AffineTransform tx = new AffineTransform();
        if (this.isFlippedHorizontally()) {
            tx.translate(base.getWidth(), 0.0);
            tx.scale(-1.0, 1.0);
        }
        if (this.isFlippedVertically()) {
            tx.translate(0.0, base.getHeight());
            tx.scale(1.0, -1.0);
        }
        if (this.isFlippedDiagonally()) {
            tx.concatenate(TX_DIAGONAL_FLIP);
        }
        return new AffineTransformOp(tx, 1).filter(base, null);
    }

    @Override
    public int getGridId() {
        if (this.gid == null) {
            return 0;
        }
        return this.gid;
    }

    @Override
    public Point getTileCoordinate() {
        return this.tileCoordinate;
    }

    @Override
    public ITilesetEntry getTilesetEntry() {
        return this.tilesetEntry;
    }

    @Override
    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (!(anObject instanceof ITile)) {
            return false;
        }
        ITile other = (ITile)anObject;
        return this.getGridId() == other.getGridId() && this.isFlippedDiagonally() == other.isFlippedDiagonally() && this.isFlippedHorizontally() == other.isFlippedHorizontally() && this.isFlippedVertically() == other.isFlippedVertically();
    }

    @Override
    public int hashCode() {
        int hash = this.getGridId();
        if (this.isFlipped()) {
            if (this.isFlippedDiagonally()) {
                hash |= 0x20000000;
            }
            if (this.isFlippedHorizontally()) {
                hash |= Integer.MIN_VALUE;
            }
            if (this.isFlippedVertically()) {
                hash |= 0x40000000;
            }
        }
        return hash ^ Objects.hashCode(this.getTilesetEntry());
    }

    public String toString() {
        return this.getGridId() + String.valueOf(this.getTilesetEntry());
    }

    void setTilesetEntry(ITilesetEntry entry) {
        this.tilesetEntry = entry;
    }

    void setGridId(int gid) {
        this.gid = gid;
    }

    void setTileCoordinate(Point tileCoordinate) {
        this.tileCoordinate = tileCoordinate;
    }

    private void beforeMarshal(Marshaller m) {
        if (this.gid != null && this.gid == 0) {
            this.gid = null;
        }
    }
}

