/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.ITerrain;
import de.gurkenlabs.litiengine.environment.tilemap.ITerrainSet;
import de.gurkenlabs.litiengine.environment.tilemap.TerrainType;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import de.gurkenlabs.litiengine.environment.tilemap.xml.WangColor;
import de.gurkenlabs.litiengine.environment.tilemap.xml.WangTile;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class WangSet
extends CustomPropertyProvider
implements ITerrainSet {
    @XmlAttribute
    private String name;
    @XmlAttribute(name="class")
    private String wangSetClass;
    @XmlAttribute
    private TerrainType type;
    @XmlAttribute
    private int tile;
    @XmlElement(type=WangColor.class)
    private List<ITerrain> wangcolor;
    @XmlElement(name="wangtile")
    private List<WangTile> wangtiles;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TerrainType getType() {
        return this.type;
    }

    @Override
    public List<ITerrain> getTerrains() {
        return this.wangcolor;
    }

    @Override
    public ITerrain[] getTerrains(int tileId) {
        int TERRAIN_COUNT = 8;
        ITerrain[] terrains = new ITerrain[8];
        for (WangTile wangtile : this.wangtiles) {
            if (wangtile.getTileId() != tileId) continue;
            for (int i = 0; i < 8; ++i) {
                int terrain = wangtile.getWangId()[i];
                terrains[i] = terrain == 0 ? null : this.getTerrains().get(wangtile.getWangId()[i] - 1);
            }
        }
        return terrains;
    }
}

