/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.EntityRenderEvent;
import de.gurkenlabs.litiengine.entities.EntityRenderedListener;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.SoundSource;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import de.gurkenlabs.litiengine.graphics.MapRenderedEvent;
import de.gurkenlabs.litiengine.graphics.MapRenderedListener;
import de.gurkenlabs.litiengine.graphics.TextRenderer;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.physics.Collision;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class DebugRenderer {
    private static List<MapRenderedListener> mapDebugListener = new CopyOnWriteArrayList<MapRenderedListener>();
    private static List<EntityRenderedListener> entityDebugListeners = new CopyOnWriteArrayList<EntityRenderedListener>();

    private DebugRenderer() {
        throw new UnsupportedOperationException();
    }

    public static void addEntityDebugListener(EntityRenderedListener listener) {
        entityDebugListeners.add(listener);
    }

    public static void removeEntityDebugListener(EntityRenderedListener listener) {
        entityDebugListeners.remove(listener);
    }

    public static void addMapRenderedListener(MapRenderedListener listener) {
        mapDebugListener.add(listener);
    }

    public static void removeMapRenderedListener(MapRenderedListener listener) {
        mapDebugListener.remove(listener);
    }

    public static void renderEntityDebugInfo(Graphics2D g, IEntity entity) {
        if (!Game.config().debug().isDebugEnabled()) {
            return;
        }
        if (Game.config().debug().renderEntityNames()) {
            DebugRenderer.drawMapId(g, entity);
        }
        if (Game.config().debug().renderHitBoxes() && entity instanceof ICombatEntity) {
            ICombatEntity ico = (ICombatEntity)entity;
            g.setColor(Color.RED);
            Game.graphics().renderOutline(g, ico.getHitBox());
        }
        if (Game.config().debug().renderBoundingBoxes()) {
            g.setColor(Color.RED);
            Game.graphics().renderOutline(g, entity.getBoundingBox());
            if (entity instanceof SoundSource) {
                SoundSource ss = (SoundSource)entity;
                int range = ss.getRange();
                float[] dash1 = new float[]{10.0f};
                BasicStroke dashed = new BasicStroke(0.5f, 0, 0, 10.0f, dash1, 0.0f);
                Game.graphics().renderOutline(g, new Ellipse2D.Double(entity.getBoundingBox().getCenterX() - (double)range, entity.getBoundingBox().getCenterY() - (double)range, (double)range * 2.0, (double)range * 2.0), dashed, true);
            }
        }
        if (Game.config().debug().renderCollisionBoxes() && entity instanceof ICollisionEntity) {
            ICollisionEntity ice = (ICollisionEntity)entity;
            g.setColor(ice.hasCollision() ? Color.RED : Color.ORANGE);
            Game.graphics().renderOutline(g, ice.getCollisionBox());
        }
        EntityRenderEvent event = new EntityRenderEvent(g, entity);
        for (EntityRenderedListener listener : entityDebugListeners) {
            listener.rendered(event);
        }
    }

    public static void renderMapDebugInfo(Graphics2D g, IMap map) {
        if (!Game.config().debug().isDebugEnabled()) {
            return;
        }
        if (Game.config().debug().renderCollisionBoxes()) {
            BasicStroke shapeStroke = new BasicStroke(1.0f / Game.world().camera().getRenderScale());
            for (Rectangle2D shape : Game.physics().getCollisionBoxes(Collision.STATIC)) {
                g.setColor(Color.RED);
                Game.graphics().renderOutline(g, (Shape)shape, shapeStroke);
            }
        }
        if (Game.config().debug().showTilesMetric()) {
            DebugRenderer.drawTileBoundingBox(g, map, Input.mouse().getMapLocation());
        }
        MapRenderedEvent event = new MapRenderedEvent(g, map);
        for (MapRenderedListener cons : mapDebugListener) {
            cons.rendered(event);
        }
    }

    private static void drawMapId(Graphics2D g, IEntity entity) {
        g.setColor(Color.RED);
        g.setFont(g.getFont().deriveFont(0, 4.0f));
        double x = Game.world().camera().getViewportDimensionCenter(entity).getX() + 10.0;
        double y = Game.world().camera().getViewportDimensionCenter(entity).getY();
        TextRenderer.render(g, Integer.toString(entity.getMapId()), x, y);
        String locationString = new DecimalFormat("##.##").format(entity.getX()) + ";" + new DecimalFormat("##.##").format(entity.getY());
        TextRenderer.render(g, locationString, x, y + 5.0);
    }

    private static void drawTileBoundingBox(Graphics2D g, IMap map, Point2D location) {
        Rectangle2D playerTile = map.getOrientation().getEnclosingTileShape(location, map).getBounds2D();
        g.setColor(Color.CYAN);
        Game.graphics().renderOutline(g, playerTile);
        Point tileLocation = map.getOrientation().getTile(location, map);
        String locationText = tileLocation.x + ", " + tileLocation.y;
        g.setFont(g.getFont().deriveFont(3.0f));
        FontMetrics fm = g.getFontMetrics();
        Point2D relative = Game.world().camera().getViewportLocation(playerTile.getX(), playerTile.getY());
        TextRenderer.render(g, locationText, (float)(relative.getX() + playerTile.getWidth() + 3.0), (float)(relative.getY() + (double)fm.getHeight()));
        List<ITile> tiles = MapUtilities.getTilesByPixelLocation(map, location);
        StringBuilder sb = new StringBuilder();
        for (ITile tile : tiles) {
            sb.append("[gid: " + tile.getGridId() + "] ");
        }
        TextRenderer.render(g, sb.toString(), (float)(relative.getX() + playerTile.getWidth() + 3.0), (float)(relative.getY() + (double)(fm.getHeight() * 2) + 2.0));
    }
}

