/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.entities.StaticShadow;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.graphics.ColorLayer;
import de.gurkenlabs.litiengine.graphics.ShapeRenderer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class StaticShadowLayer
extends ColorLayer {
    public StaticShadowLayer(Environment environment, Color color) {
        super(environment, color);
    }

    @Override
    protected void renderSection(Graphics2D g, Rectangle2D section) {
        Color color = this.getColor();
        g.setColor(color);
        Area ar = new Area();
        for (StaticShadow staticShadow : this.getEnvironment().getStaticShadows()) {
            if (staticShadow.getArea() == null || !staticShadow.getArea().intersects(section)) continue;
            Area staticShadowArea = staticShadow.getArea();
            ar.add(staticShadowArea);
        }
        ShapeRenderer.render(g, ar);
    }

    @Override
    protected void clearSection(Graphics2D g, Rectangle2D section) {
        g.setComposite(AlphaComposite.getInstance(1));
        g.fill(section);
        g.setComposite(AlphaComposite.getInstance(3));
    }
}

