/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.animation;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.AnimationInfo;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.animation.Animation;
import de.gurkenlabs.litiengine.graphics.animation.AnimationController;
import de.gurkenlabs.litiengine.graphics.animation.IEntityAnimationController;
import de.gurkenlabs.litiengine.resources.Resources;
import java.awt.geom.AffineTransform;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;

public class EntityAnimationController<T extends IEntity>
extends AnimationController
implements IEntityAnimationController<T> {
    private final List<AnimationRule<T>> animationRules = new CopyOnWriteArrayList<AnimationRule<T>>();
    private final T entity;
    private String spritePrefix;
    private boolean autoScaling;

    public EntityAnimationController(T entity) {
        this.entity = entity;
        if (entity != null) {
            this.spritePrefix = Game.random().choose(EntityAnimationController.getDefaultSpritePrefixes(entity.getClass()));
        }
    }

    public EntityAnimationController(T entity, Animation defaultAnimation, Animation ... animations) {
        super(defaultAnimation, animations);
        this.entity = entity;
        this.spritePrefix = Game.random().choose(EntityAnimationController.getDefaultSpritePrefixes(entity.getClass()));
    }

    public EntityAnimationController(T entity, Spritesheet sprite) {
        this(entity, sprite, true);
    }

    public EntityAnimationController(T entity, Spritesheet sprite, boolean loop) {
        this(entity, new Animation(sprite, loop, Resources.spritesheets().getCustomKeyFrameDurations(sprite)), new Animation[0]);
    }

    public static String[] getDefaultSpritePrefixes(Class<?> cls) {
        AnimationInfo animationInfo = cls.getAnnotation(AnimationInfo.class);
        if (animationInfo != null && animationInfo.spritePrefix().length > 0) {
            return animationInfo.spritePrefix();
        }
        return new String[]{cls.getSimpleName().toLowerCase()};
    }

    @Override
    public synchronized void addRule(Predicate<? super T> rule, Function<? super T, String> animationName, int priority) {
        int min = 0;
        int max = this.animationRules.size();
        while (min < max - 1) {
            int midpoint = (min + max) / 2;
            if (priority > this.animationRules.get(midpoint).getPriority()) {
                min = midpoint + 1;
                continue;
            }
            max = midpoint;
        }
        this.animationRules.add(min, new AnimationRule<T>(rule, animationName, priority));
    }

    @Override
    public void addRule(Predicate<? super T> rule, Function<? super T, String> animationName) {
        this.addRule(rule, animationName, 0);
    }

    public T getEntity() {
        return this.entity;
    }

    @Override
    public void update() {
        super.update();
        if (Game.world().environment() == null || Game.world().environment().getMap() == null) {
            return;
        }
        if (this.getCurrent() != null && !this.getCurrent().isLooping() && this.getCurrent().isPlaying()) {
            return;
        }
        if (this.getEntity() == null) {
            return;
        }
        for (AnimationRule<T> animationRule : this.animationRules) {
            if (!animationRule.getCondition().test(this.getEntity())) continue;
            String animationName = animationRule.getAnimationName().apply(this.getEntity());
            if (this.getCurrent() != null && (animationName == null || animationName.isEmpty() || this.getCurrent().getName().equalsIgnoreCase(animationName))) break;
            this.play(animationName);
            break;
        }
    }

    protected String getSpritePrefix() {
        return this.spritePrefix;
    }

    protected void setSpritePrefix(String prefix) {
        this.spritePrefix = prefix;
    }

    @Override
    public boolean isAutoScaling() {
        return this.autoScaling;
    }

    @Override
    public void setAutoScaling(boolean scaling) {
        this.autoScaling = scaling;
    }

    @Override
    public void scaleSprite(float scaleX, float scaleY) {
        AffineTransform trans = new AffineTransform();
        trans.scale(scaleX, scaleY);
        this.setAffineTransform(trans);
    }

    @Override
    public void scaleSprite(float scale) {
        this.scaleSprite(scale, scale);
    }

    protected static class AnimationRule<T extends IEntity> {
        private final Predicate<? super T> condition;
        private final Function<? super T, String> animationName;
        private int priority;

        public AnimationRule(Predicate<? super T> condition, Function<? super T, String> animationName, int priority) {
            this.condition = condition;
            this.animationName = animationName;
            this.priority = priority;
        }

        Predicate<? super T> getCondition() {
            return this.condition;
        }

        Function<? super T, String> getAnimationName() {
            return this.animationName;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }
    }
}

