/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters.particles;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.ITimeToLive;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.emitters.xml.EmitterData;
import de.gurkenlabs.litiengine.physics.Collision;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class Particle
implements ITimeToLive {
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private long aliveTick;
    private long aliveTime;
    private float angle;
    private float deltaAngle;
    private Collision collisionType;
    private Color color = DEFAULT_COLOR;
    private float deltaHeight;
    private float deltaWidth;
    private float velocityX;
    private float velocityY;
    private float outlineThickness;
    private boolean outlineOnly;
    private boolean antiAliasing;
    private float accelerationX;
    private float accelerationY;
    private float height;
    private int timeToLive;
    private float width;
    private float x;
    private float y;
    private RenderType customRenderType = RenderType.NONE;
    private boolean useCustomRenderType;
    private boolean fade;
    private boolean fadeOnCollision;
    private boolean colliding;
    private boolean continuousCollision;
    private boolean stopOnCollision;

    protected Particle(float width, float height) {
        this.setWidth(width);
        this.setHeight(height);
        this.collisionType = Collision.NONE;
        this.fade = true;
        this.setStopOnCollision(true);
        this.setContinuousCollision(false);
    }

    @Override
    public long getAliveTime() {
        return this.aliveTime;
    }

    public Rectangle2D getBoundingBox(Point2D origin) {
        return new Rectangle2D.Double(origin.getX() + (double)this.getX(), origin.getY() + (double)this.getY(), this.getWidth(), this.getHeight());
    }

    public Collision getCollisionType() {
        return this.collisionType;
    }

    public Color getColor() {
        return this.color;
    }

    public float getDeltaHeight() {
        return this.deltaHeight;
    }

    public float getDeltaWidth() {
        return this.deltaWidth;
    }

    public float getVelocityX() {
        return this.velocityX;
    }

    public float getVelocityY() {
        return this.velocityY;
    }

    public float getAccelerationX() {
        return this.accelerationX;
    }

    public float getAccelerationY() {
        return this.accelerationY;
    }

    public float getAngle() {
        return this.angle;
    }

    public float getDeltaAngle() {
        return this.deltaAngle;
    }

    public float getHeight() {
        return this.height;
    }

    public float getOutlineThickness() {
        return this.outlineThickness;
    }

    public boolean isOutlineOnly() {
        return this.outlineOnly;
    }

    public boolean isAntiAliased() {
        return this.antiAliasing;
    }

    public float getOpacity() {
        if (this.isFading() && this.getTimeToLive() > 0) {
            float maxAlpha = (float)this.getColor().getAlpha() / 255.0f;
            float progress = (float)this.getAliveTime() / (float)this.getTimeToLive();
            return Math.clamp(maxAlpha - progress * maxAlpha, 0.0f, 1.0f);
        }
        return 1.0f;
    }

    public Point2D getRenderLocation(Point2D effectLocation) {
        Point2D newEffectLocation = Game.screens() != null ? Game.world().camera().getViewportLocation(effectLocation) : effectLocation;
        return this.getAbsoluteLocation(newEffectLocation);
    }

    public RenderType getCustomRenderType() {
        return this.customRenderType;
    }

    @Override
    public int getTimeToLive() {
        return this.timeToLive;
    }

    public float getWidth() {
        return this.width;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public boolean isFading() {
        return this.fade;
    }

    public boolean isFadingOnCollision() {
        return this.fadeOnCollision;
    }

    public boolean isContinuousCollisionEnabled() {
        return this.continuousCollision;
    }

    public boolean isStoppingOnCollision() {
        return this.stopOnCollision;
    }

    public abstract void render(Graphics2D var1, Point2D var2);

    public Particle setCollisionType(Collision collisionType) {
        this.collisionType = collisionType;
        return this;
    }

    public Particle setContinuousCollision(boolean ccd) {
        this.continuousCollision = ccd;
        return this;
    }

    public Particle setStopOnCollision(boolean stopOnCollision) {
        this.stopOnCollision = stopOnCollision;
        return this;
    }

    public Particle setColor(Color color) {
        if (color != null) {
            this.color = color;
        }
        return this;
    }

    public Particle setDeltaHeight(float deltaHeight) {
        this.deltaHeight = deltaHeight;
        return this;
    }

    public Particle setAccelerationX(float accelerationX) {
        this.accelerationX = accelerationX;
        return this;
    }

    public Particle setAccelerationY(float accelerationY) {
        this.accelerationY = accelerationY;
        return this;
    }

    public Particle setAngle(float angle) {
        this.angle = angle;
        return this;
    }

    public Particle setDeltaAngle(float deltaAngle) {
        this.deltaAngle = deltaAngle;
        return this;
    }

    public Particle setDeltaWidth(float deltaWidth) {
        this.deltaWidth = deltaWidth;
        return this;
    }

    public Particle setVelocityX(float velocityX) {
        this.velocityX = velocityX;
        return this;
    }

    public Particle setVelocityY(float velocityY) {
        this.velocityY = velocityY;
        return this;
    }

    public Particle setFade(boolean fade) {
        this.fade = fade;
        return this;
    }

    public Particle setFadeOnCollision(boolean fadeOnCollision) {
        this.fadeOnCollision = fadeOnCollision;
        return this;
    }

    public Particle setHeight(float height) {
        this.height = height;
        return this;
    }

    public Particle setOutlineThickness(float outlineThickness) {
        this.outlineThickness = outlineThickness;
        return this;
    }

    public Particle setOutlineOnly(boolean outlineOnly) {
        this.outlineOnly = outlineOnly;
        return this;
    }

    public Particle setAntiAliasing(boolean antiAliasing) {
        this.antiAliasing = antiAliasing;
        return this;
    }

    public Particle setCustomRenderType(RenderType renderType) {
        this.customRenderType = renderType;
        this.useCustomRenderType = true;
        return this;
    }

    public Particle setWidth(float width) {
        this.width = width;
        return this;
    }

    public Particle setX(float x) {
        this.x = x;
        return this;
    }

    public Particle setY(float y) {
        this.y = y;
        return this;
    }

    public Particle setTimeToLive(int ttl) {
        this.timeToLive = ttl;
        return this;
    }

    public Particle init(EmitterData data) {
        this.setX((float)data.getParticleOffsetX().get());
        this.setY((float)data.getParticleOffsetY().get());
        this.setAccelerationX((float)data.getAccelerationX().get());
        this.setAccelerationY((float)data.getAccelerationY().get());
        this.setVelocityX((float)data.getVelocityX().get());
        this.setVelocityY((float)data.getVelocityY().get());
        this.setDeltaWidth((float)data.getDeltaWidth().get());
        this.setDeltaHeight((float)data.getDeltaHeight().get());
        this.setAngle((float)data.getAngle().get());
        this.setDeltaAngle((float)data.getDeltaAngle().get());
        this.setTimeToLive((int)data.getParticleTTL().get());
        this.setColor(Game.random().choose(data.getDecodedColors()));
        this.setOutlineThickness((float)data.getOutlineThickness().get());
        this.setCollisionType(data.getCollision());
        this.setOutlineOnly(data.isOutlineOnly());
        this.setAntiAliasing(data.isAntiAliased());
        this.setFade(data.isFading());
        this.setFadeOnCollision(data.isFadingOnCollision());
        return this;
    }

    @Override
    public boolean timeToLiveReached() {
        return this.getTimeToLive() > 0 && this.getAliveTime() >= (long)this.getTimeToLive();
    }

    public void update(Point2D emitterOrigin, float updateRatio) {
        if (this.aliveTick == 0L) {
            this.aliveTick = Game.time().now();
        }
        this.aliveTime = Game.time().since(this.aliveTick);
        if (this.timeToLiveReached()) {
            return;
        }
        if (this.colliding) {
            return;
        }
        if (this.getDeltaWidth() != 0.0f) {
            this.width += this.getDeltaWidth() * updateRatio;
        }
        if (this.getDeltaHeight() != 0.0f) {
            this.height += this.getDeltaHeight() * updateRatio;
        }
        if (this.getDeltaAngle() != 0.0f) {
            this.angle += this.getDeltaAngle() * updateRatio;
        }
        if (this.hasRayCastCollision(emitterOrigin, updateRatio)) {
            return;
        }
        if (this.getAccelerationX() != 0.0f) {
            this.velocityX += this.getAccelerationX() * updateRatio;
        }
        if (this.getAccelerationY() != 0.0f) {
            this.velocityY += this.getAccelerationY() * updateRatio;
        }
    }

    protected boolean hasRayCastCollision(Point2D emitterOrigin, float updateRatio) {
        float targetX = this.x + this.getVelocityX() * updateRatio;
        float targetY = this.y + this.getVelocityY() * updateRatio;
        if (targetX == this.x && targetY == this.y) {
            return true;
        }
        if (this.checkForCollision(emitterOrigin, targetX, targetY)) {
            return true;
        }
        if (this.getVelocityX() != 0.0f) {
            this.x = targetX;
        }
        if (this.getVelocityY() != 0.0f) {
            this.y = targetY;
        }
        return false;
    }

    private boolean checkForCollision(Point2D emitterOrigin, float targetX, float targetY) {
        if (this.isStoppingOnCollision() && this.colliding) {
            return true;
        }
        if (this.isContinuousCollisionEnabled()) {
            Point2D start = this.getAbsoluteLocation(emitterOrigin);
            double endX = emitterOrigin.getX() + (double)targetX;
            double endY = emitterOrigin.getY() + (double)targetY;
            Line2D.Double ray = new Line2D.Double(start.getX(), start.getY(), endX, endY);
            if (this.getCollisionType() != Collision.NONE && Game.physics() != null && Game.physics().collides((Line2D)ray, this.getCollisionType())) {
                this.collide();
                return true;
            }
        } else if (this.getCollisionType() != Collision.NONE && Game.physics() != null && Game.physics().collides(this.getBoundingBox(emitterOrigin).getBounds2D(), this.getCollisionType())) {
            this.collide();
            return true;
        }
        return false;
    }

    private void collide() {
        if (!this.colliding) {
            this.colliding = true;
            if (this.isFadingOnCollision()) {
                this.setFade(true);
            }
        }
    }

    public Point2D getAbsoluteLocation(Point2D effectLocation) {
        return new Point2D.Float(this.getAbsoluteX(effectLocation), this.getAbsoluteY(effectLocation));
    }

    protected float getAbsoluteX(Point2D emitterOrigin) {
        return (float)(emitterOrigin.getX() + (double)this.getX() - (double)this.getWidth() / 2.0);
    }

    protected float getAbsoluteY(Point2D emitterOrigin) {
        return (float)(emitterOrigin.getY() + (double)this.getY() - (double)this.getHeight() / 2.0);
    }

    public boolean usesCustomRenderType() {
        return this.useCustomRenderType;
    }
}

