/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.FontIcon;
import de.gurkenlabs.litiengine.gui.ImageComponent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class CheckBox
extends ImageComponent {
    public static final FontIcon CHECK = new FontIcon(ICON_FONT, "\ue847");
    public static final FontIcon CROSS = new FontIcon(ICON_FONT, "\ue843");
    private final List<Consumer<Boolean>> changeConsumer = new CopyOnWriteArrayList<Consumer<Boolean>>();
    private boolean checked;

    public CheckBox(double x, double y, double width, double height, Spritesheet spritesheet, boolean checked) {
        super(x, y, width, height, spritesheet, "", null);
        this.setFont(CHECK.getFont());
        this.setChecked(checked);
        this.refreshText();
        this.onClicked(e -> this.toggleChecked());
    }

    public List<Consumer<Boolean>> getChangeConsumer() {
        return this.changeConsumer;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void onChange(Consumer<Boolean> c) {
        this.getChangeConsumer().add(c);
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.getChangeConsumer().forEach(consumer -> consumer.accept(this.isChecked()));
        this.refreshText();
    }

    private void refreshText() {
        if (this.checked) {
            this.setText(CHECK.getText());
        } else {
            this.setText(CROSS.getText());
        }
    }

    private void toggleChecked() {
        this.setChecked(!this.checked);
    }
}

