/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.graphics.ImageRenderer;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.GuiComponent;
import de.gurkenlabs.litiengine.gui.ImageScaleMode;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.util.Imaging;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;

public class ImageComponent
extends GuiComponent {
    public static final int BACKGROUND_INDEX = 0;
    public static final int BACKGROUND_HOVER_INDEX = 1;
    public static final int BACKGROUND_PRESSED_INDEX = 2;
    public static final int BACKGROUND_DISABLED_INDEX = 3;
    private BufferedImage baseImage;
    private BufferedImage scaledImage;
    private Spritesheet spritesheet;
    private ImageScaleMode imageScaleMode = ImageScaleMode.NORMAL;
    private ImageScaleMode spritesheetScaleMode = ImageScaleMode.NORMAL;
    private int imageScaleInterpolation = 3;
    private int spritesheetScaleInterpolation = 1;
    private float spritesheetScaleFactor = 1.0f;
    private Align imageAlign = Align.CENTER;
    private Valign imageValign = Valign.MIDDLE;
    private double horizontalImagePadding;
    private double verticalImagePadding;

    public ImageComponent(double x, double y, Image image) {
        super(x, y, image.getWidth(null), image.getHeight(null));
        this.baseImage = (BufferedImage)image;
    }

    public ImageComponent(double x, double y, double width, double height) {
        super(x, y, width, height);
    }

    public ImageComponent(double x, double y, double width, double height, String text) {
        super(x, y, width, height);
        Font defFont = new JLabel().getFont().deriveFont((float)(this.getHeight() * 3.0 / 6.0));
        if (this.getFont() == null) {
            this.setFont(defFont);
        }
        this.setText(text);
    }

    public ImageComponent(double x, double y, double width, double height, Image image) {
        super(x, y, width, height);
        this.setImage(image);
    }

    public ImageComponent(double x, double y, double width, double height, Spritesheet spritesheet, String text, Image image) {
        this(x, y, width, height, text);
        this.spritesheet = spritesheet;
        this.setImageAlign(Align.LEFT);
        this.setImageValign(Valign.TOP);
        if (image != null) {
            this.baseImage = (BufferedImage)image;
        }
    }

    public Image getBackground() {
        if (this.getSpritesheet() == null) {
            return null;
        }
        String cacheKey = String.format("%d_%b_%b_%b_%.0f_%.0f_%s_%d", this.getSpritesheet().getName().hashCode(), this.isHovered(), this.isPressed(), this.isEnabled(), this.getWidth(), this.getHeight(), this.getSpritesheetScaleMode().name().toLowerCase(), this.getSpritesheetScaleInterpolation());
        return Resources.images().tryGet(cacheKey).orElseGet(() -> {
            BufferedImage img;
            if (this.getSpritesheetScaleMode() == ImageScaleMode.SLICE) {
                img = Imaging.nineSlice(this.getSpritesheet(), (int)this.getWidth(), (int)this.getHeight(), this.getSpritesheetScaleFactor());
            } else {
                int spriteIndex = 0;
                if (!this.isEnabled() && this.getSpritesheet().getTotalNumberOfSprites() > 3) {
                    spriteIndex = 3;
                } else if (this.isPressed() && this.getSpritesheet().getTotalNumberOfSprites() > 2) {
                    spriteIndex = 2;
                } else if (this.isHovered() && this.getSpritesheet().getTotalNumberOfSprites() > 1) {
                    spriteIndex = 1;
                }
                img = Imaging.scale(this.getSpritesheet().getSprite(spriteIndex), (int)this.getWidth(), (int)this.getHeight(), this.spritesheetScaleInterpolation);
            }
            if (img != null) {
                Resources.images().add(cacheKey, img);
            }
            return img;
        });
    }

    public void rescaleImage() {
        boolean keepRatio;
        if (this.baseImage == null) {
            this.scaledImage = null;
            return;
        }
        int imageWidth = (int)(2.0 * this.getHorizontalImagePadding() > this.getWidth() ? this.getWidth() : this.getWidth() - 2.0 * this.getHorizontalImagePadding());
        int imageHeight = (int)(2.0 * this.getVerticalImagePadding() > this.getHeight() ? this.getHeight() : this.getHeight() - 2.0 * this.getVerticalImagePadding());
        switch (this.getImageScaleMode()) {
            case STRETCH: {
                keepRatio = false;
                break;
            }
            case FIT: {
                keepRatio = true;
                break;
            }
            default: {
                return;
            }
        }
        String cacheKey = String.format("%s_%dx%d_%b", this.baseImage.hashCode(), imageWidth, imageHeight, keepRatio);
        this.scaledImage = Resources.images().tryGet(cacheKey).orElseGet(() -> {
            BufferedImage scaled = Imaging.scale(this.baseImage, imageWidth, imageHeight, this.getImageScaleInterpolation(), keepRatio);
            Resources.images().add(cacheKey, scaled);
            return scaled;
        });
    }

    public BufferedImage getImage() {
        return this.scaledImage != null ? this.scaledImage : this.baseImage;
    }

    public Align getImageAlign() {
        return this.imageAlign;
    }

    public ImageScaleMode getImageScaleMode() {
        return this.imageScaleMode;
    }

    public ImageScaleMode getSpritesheetScaleMode() {
        return this.spritesheetScaleMode;
    }

    public float getSpritesheetScaleFactor() {
        return this.spritesheetScaleFactor;
    }

    public double getHorizontalImagePadding() {
        return this.horizontalImagePadding;
    }

    public void setHorizontalImagePadding(double horizontalImagePadding) {
        this.horizontalImagePadding = horizontalImagePadding;
        this.rescaleImage();
    }

    public double getVerticalImagePadding() {
        return this.verticalImagePadding;
    }

    public void setVerticalImagePadding(double verticalImagePadding) {
        this.verticalImagePadding = verticalImagePadding;
        this.rescaleImage();
    }

    public Valign getImageValign() {
        return this.imageValign;
    }

    @Override
    public void render(Graphics2D g) {
        BufferedImage img;
        if (this.isSuspended() || !this.isVisible()) {
            return;
        }
        Image bg = this.getBackground();
        if (bg != null) {
            ImageRenderer.render(g, bg, this.getLocation());
        }
        if ((img = this.getImage()) != null) {
            double imageX = this.getImageAlign().getLocation(this.getWidth(), img.getWidth(), true);
            double imageY = this.getImageValign().getLocation(this.getHeight(), img.getHeight(), true);
            ImageRenderer.render(g, img, this.getX() + imageX, this.getY() + imageY);
        }
        super.render(g);
    }

    public void setImage(Image image) {
        this.baseImage = (BufferedImage)image;
        this.rescaleImage();
    }

    public void setImageScaleMode(ImageScaleMode imageScaleMode) {
        this.imageScaleMode = imageScaleMode;
        this.rescaleImage();
    }

    public int getImageScaleInterpolation() {
        return this.imageScaleInterpolation;
    }

    public void setImageScaleInterpolation(int imageScaleInterpolation) {
        this.imageScaleInterpolation = imageScaleInterpolation;
        this.rescaleImage();
    }

    public void setSpritesheetScaleMode(ImageScaleMode spritesheetScaleMode) {
        this.spritesheetScaleMode = spritesheetScaleMode;
        this.rescaleImage();
    }

    public void setSpritesheetScaleFactor(float spritesheetScaleFactor) {
        this.spritesheetScaleFactor = spritesheetScaleFactor;
    }

    public int getSpritesheetScaleInterpolation() {
        return this.spritesheetScaleInterpolation;
    }

    public void setSpritesheetScaleInterpolation(int spritesheetScaleInterpolation) {
        this.spritesheetScaleInterpolation = spritesheetScaleInterpolation;
        this.rescaleImage();
    }

    public void setSpritesheet(Spritesheet spr) {
        this.spritesheet = spr;
    }

    public void setSpritesheet(Spritesheet spr, ImageScaleMode scaleMode) {
        this.setSpritesheet(spr);
        this.setSpritesheetScaleMode(scaleMode);
    }

    public void setSpritesheet(Spritesheet spr, ImageScaleMode scaleMode, float scaleFactor) {
        this.setSpritesheet(spr, scaleMode);
        this.setSpritesheetScaleFactor(scaleFactor);
    }

    public void setImageAlign(Align imageAlign) {
        this.imageAlign = imageAlign;
    }

    public void setImageValign(Valign imageValign) {
        this.imageValign = imageValign;
    }

    @Override
    public void setHeight(double height) {
        super.setHeight(height);
        this.rescaleImage();
    }

    @Override
    public void setWidth(double width) {
        super.setWidth(width);
        this.rescaleImage();
    }

    protected Spritesheet getSpritesheet() {
        return this.spritesheet;
    }
}

