/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.ImageComponent;
import de.gurkenlabs.litiengine.gui.ImageComponentList;
import de.gurkenlabs.litiengine.gui.Orientation;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.IntConsumer;

public class Menu
extends ImageComponentList {
    private int currentSelection;
    private final String[] items;
    private final List<IntConsumer> selectionChangeConsumers;
    private final Orientation orientation;

    public Menu(double x, double y, double width, double height, Orientation orientation, String ... items) {
        this(x, y, width, height, null, orientation, items);
    }

    public Menu(double x, double y, double width, double height, String ... items) {
        this(x, y, width, height, null, Orientation.VERTICAL, items);
    }

    public Menu(double x, double y, double width, double height, Spritesheet background, Orientation orientation, String ... items) {
        super(x, y, width, height, orientation == Orientation.VERTICAL ? items.length : 1, orientation == Orientation.VERTICAL ? 1 : items.length, null, background);
        this.items = items;
        this.selectionChangeConsumers = new CopyOnWriteArrayList<IntConsumer>();
        this.orientation = orientation;
    }

    public int getCurrentSelection() {
        return this.currentSelection;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void onChange(IntConsumer cons) {
        this.selectionChangeConsumers.add(cons);
    }

    @Override
    public void prepare() {
        super.prepare();
        for (int i = 0; i < this.items.length; ++i) {
            ImageComponent menuButton = this.getCellComponents().get(i);
            menuButton.setText(this.items[i]);
            menuButton.onClicked(c -> this.setCurrentSelection(this.getCellComponents().indexOf(menuButton)));
        }
    }

    public void setCurrentSelection(int newSelection) {
        this.currentSelection = newSelection;
        for (int i = 0; i < this.getCellComponents().size(); ++i) {
            this.getCellComponents().get(this.getCurrentSelection()).setSelected(i == this.getCurrentSelection());
        }
        this.selectionChangeConsumers.forEach(c -> c.accept(this.getCurrentSelection()));
    }
}

