/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import de.gurkenlabs.litiengine.input.IMouse;
import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public final class Mouse
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
IMouse,
IUpdateable {
    private static final Logger log = Logger.getLogger(Mouse.class.getName());
    private final Collection<IMouse.MouseClickedListener> mouseClickedListeners = ConcurrentHashMap.newKeySet();
    private final Collection<IMouse.MouseDraggedListener> mouseDraggedListeners = ConcurrentHashMap.newKeySet();
    private final Collection<IMouse.MouseMovedListener> mouseMovedListeners = ConcurrentHashMap.newKeySet();
    private final Collection<IMouse.MousePressedListener> mousePressedListeners = ConcurrentHashMap.newKeySet();
    private final Collection<IMouse.MousePressingListener> mousePressingListeners = ConcurrentHashMap.newKeySet();
    private final Collection<IMouse.MouseReleasedListener> mouseReleasedListeners = ConcurrentHashMap.newKeySet();
    private final Collection<MouseListener> mouseListeners = ConcurrentHashMap.newKeySet();
    private final Collection<MouseMotionListener> mouseMotionListeners = ConcurrentHashMap.newKeySet();
    private final Collection<MouseWheelListener> mouseWheelListeners = ConcurrentHashMap.newKeySet();
    private final Robot robot;
    private final float sensitivity;
    private boolean grabMouse;
    private boolean pressed;
    private boolean isLeftMouseButtonDown;
    private boolean isRightMouseButtonDown;
    private Point2D lastLocation;
    private Point2D location;
    private MouseEvent updateLocation;
    private boolean updatingLocation;

    Mouse() throws AWTException {
        try {
            this.robot = new Robot();
            this.robot.setAutoDelay(0);
        }
        catch (AWTException e) {
            log.log(Level.SEVERE, "The mouse input could not be initialized.");
            throw e;
        }
        this.lastLocation = this.location = new Point2D.Double(Game.world().camera().getViewport().getCenterX(), Game.world().camera().getViewport().getCenterY());
        this.sensitivity = Game.config().input().getMouseSensitivity();
        this.grabMouse = false;
    }

    @Override
    public void update() {
        if (this.isPressed()) {
            for (IMouse.MousePressingListener listener : this.mousePressingListeners) {
                listener.mousePressing();
            }
        }
        if (this.updateLocation != null && !this.updatingLocation) {
            this.updatingLocation = true;
            try {
                this.setLocation(this.updateLocation);
                this.updateLocation = null;
            }
            finally {
                this.updatingLocation = false;
            }
        }
    }

    @Override
    public Point2D getLocation() {
        return this.location;
    }

    @Override
    public Point2D getMapLocation() {
        return Game.world().camera().getMapLocation(new Point2D.Double(this.getLocation().getX() / (double)Game.world().camera().getRenderScale(), this.getLocation().getY() / (double)Game.world().camera().getRenderScale()));
    }

    @Override
    public Point getTile() {
        return MapUtilities.getTile(this.getMapLocation());
    }

    @Override
    public boolean isGrabMouse() {
        return this.grabMouse;
    }

    @Override
    public boolean isLeftButtonPressed() {
        return this.isLeftMouseButtonDown;
    }

    @Override
    public boolean isPressed() {
        return this.pressed;
    }

    @Override
    public boolean isRightButtonPressed() {
        return this.isRightMouseButtonDown;
    }

    @Override
    public boolean isLeftButton(MouseEvent event) {
        return SwingUtilities.isLeftMouseButton(event);
    }

    @Override
    public boolean isRightButton(MouseEvent event) {
        return SwingUtilities.isRightMouseButton(event);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.updateLocation(e);
        MouseEvent wrappedEvent = this.createEvent(e);
        this.mouseListeners.forEach(listener -> listener.mouseClicked(wrappedEvent));
        for (IMouse.MouseClickedListener listener2 : this.mouseClickedListeners) {
            listener2.mouseClicked(wrappedEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateLocation(e);
        MouseEvent wrappedEvent = this.createEvent(e);
        this.mouseMotionListeners.forEach(listener -> listener.mouseDragged(wrappedEvent));
        for (IMouse.MouseDraggedListener listener2 : this.mouseDraggedListeners) {
            listener2.mouseDragged(wrappedEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.grabMouse) {
            this.lastLocation = e.getPoint();
            this.location = e.getPoint();
        } else {
            this.updateLocation(e);
        }
        MouseEvent wrappedEvent = this.createEvent(e);
        this.mouseListeners.forEach(listener -> listener.mouseEntered(wrappedEvent));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.updateLocation(e);
        MouseEvent wrappedEvent = this.createEvent(e);
        this.mouseListeners.forEach(listener -> listener.mouseExited(wrappedEvent));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateLocation(e);
        MouseEvent wrappedEvent = this.createEvent(e);
        this.mouseMotionListeners.forEach(listener -> listener.mouseMoved(wrappedEvent));
        for (IMouse.MouseMovedListener listener2 : this.mouseMovedListeners) {
            listener2.mouseMoved(wrappedEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.updateLocation(e);
        this.setPressed(true);
        MouseEvent wrappedEvent = this.createEvent(e);
        this.mouseListeners.forEach(listener -> listener.mousePressed(wrappedEvent));
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.isLeftMouseButtonDown = true;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            this.isRightMouseButtonDown = true;
        }
        for (IMouse.MousePressedListener listener2 : this.mousePressedListeners) {
            listener2.mousePressed(wrappedEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateLocation(e);
        this.setPressed(false);
        MouseEvent wrappedEvent = this.createEvent(e);
        this.mouseListeners.forEach(listener -> listener.mouseReleased(wrappedEvent));
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.isLeftMouseButtonDown = false;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            this.isRightMouseButtonDown = false;
        }
        for (IMouse.MouseReleasedListener listener2 : this.mouseReleasedListeners) {
            listener2.mouseReleased(wrappedEvent);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.mouseWheelListeners.forEach(listener -> listener.mouseWheelMoved(e));
    }

    @Override
    public void onClicked(IMouse.MouseClickedListener listener) {
        this.mouseClickedListeners.add(listener);
    }

    @Override
    public void removeMouseClickedListener(IMouse.MouseClickedListener listener) {
        this.mouseClickedListeners.remove(listener);
    }

    @Override
    public void onDragged(IMouse.MouseDraggedListener listener) {
        this.mouseDraggedListeners.add(listener);
    }

    @Override
    public void removeMouseDraggedListener(IMouse.MouseDraggedListener listener) {
        this.mouseDraggedListeners.remove(listener);
    }

    @Override
    public void onMoved(IMouse.MouseMovedListener listener) {
        this.mouseMovedListeners.add(listener);
    }

    @Override
    public void removeMouseMovedListener(IMouse.MouseMovedListener listener) {
        this.mouseMovedListeners.remove(listener);
    }

    @Override
    public void onPressed(IMouse.MousePressedListener listener) {
        this.mousePressedListeners.add(listener);
    }

    @Override
    public void removeMousePressedListener(IMouse.MousePressedListener listener) {
        this.mousePressedListeners.remove(listener);
    }

    @Override
    public void onPressing(IMouse.MousePressingListener listener) {
        this.mousePressingListeners.add(listener);
    }

    @Override
    public void removeMousePressingListener(IMouse.MousePressingListener listener) {
        this.mousePressingListeners.remove(listener);
    }

    @Override
    public void onReleased(IMouse.MouseReleasedListener listener) {
        this.mouseReleasedListeners.add(listener);
    }

    @Override
    public void removeMouseReleasedListener(IMouse.MouseReleasedListener listener) {
        this.mouseReleasedListeners.remove(listener);
    }

    @Override
    public void onWheelMoved(MouseWheelListener listener) {
        this.mouseWheelListeners.add(listener);
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.mouseWheelListeners.remove(listener);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        if (this.mouseListeners.contains(listener)) {
            return;
        }
        this.mouseListeners.add(listener);
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        this.mouseListeners.remove(listener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener listener) {
        if (this.mouseMotionListeners.contains(listener)) {
            return;
        }
        this.mouseMotionListeners.add(listener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListeners.remove(listener);
    }

    @Override
    public void clearExplicitListeners() {
        this.mouseClickedListeners.clear();
        this.mouseDraggedListeners.clear();
        this.mouseMovedListeners.clear();
        this.mousePressedListeners.clear();
        this.mousePressingListeners.clear();
        this.mouseReleasedListeners.clear();
    }

    @Override
    public void setGrabMouse(boolean grab) {
        this.grabMouse = grab;
        if (this.isGrabMouse()) {
            Game.window().cursor().hideDefaultCursor();
        } else if (!Game.window().cursor().isVisible()) {
            Game.window().cursor().showDefaultCursor();
        }
    }

    @Override
    public void setLocation(Point2D adjustMouse) {
        if (adjustMouse == null) {
            return;
        }
        this.location = adjustMouse;
        this.lastLocation = adjustMouse;
        MouseEvent mouseEvent = new MouseEvent(Game.window().getRenderComponent(), 503, 0L, 0, (int)this.getLocation().getX(), (int)this.getLocation().getY(), 0, false, 0);
        MouseEvent wrappedEvent = this.createEvent(mouseEvent);
        for (IMouse.MouseMovedListener listener : this.mouseMovedListeners) {
            listener.mouseMoved(wrappedEvent);
        }
    }

    @Override
    public void setLocation(double x, double y) {
        this.setLocation(new Point2D.Double(x, y));
    }

    private MouseEvent createEvent(MouseEvent original) {
        return new MouseEvent(original.getComponent(), original.getID(), original.getWhen(), original.getModifiers(), (int)this.getLocation().getX(), (int)this.getLocation().getY(), original.getXOnScreen(), original.getYOnScreen(), original.getClickCount(), original.isPopupTrigger(), original.getButton());
    }

    private void setLocation(MouseEvent e) {
        double diffY;
        double diffX;
        if (this.grabMouse && !Game.window().isFocusOwner()) {
            return;
        }
        if (!this.grabMouse) {
            diffX = (double)e.getX() - this.lastLocation.getX();
            diffY = (double)e.getY() - this.lastLocation.getY();
            this.lastLocation = new Point(e.getX(), e.getY());
        } else {
            double screenCenterX = Game.window().getResolution().getWidth() * 0.5;
            double screenCenterY = Game.window().getResolution().getHeight() * 0.5;
            Point screenLocation = Game.window().getLocationOnScreen();
            int grabX = (int)((double)screenLocation.x + screenCenterX);
            int grabY = (int)((double)screenLocation.y + screenCenterY);
            this.robot.mouseMove(grabX, grabY);
            diffX = (double)e.getXOnScreen() - (double)grabX;
            diffY = (double)e.getYOnScreen() - (double)grabY;
        }
        double newX = this.getLocation().getX() + diffX * (double)this.sensitivity;
        double newY = this.getLocation().getY() + diffY * (double)this.sensitivity;
        newX = Math.clamp(newX, 0.0, Game.window().getResolution().getWidth());
        newY = Math.clamp(newY, 0.0, Game.window().getResolution().getHeight());
        this.location = new Point2D.Double(newX, newY);
    }

    private void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    private void updateLocation(MouseEvent mouseEvent) {
        if (this.updatingLocation) {
            return;
        }
        this.updateLocation = mouseEvent;
    }
}

