/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.resources;

import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.resources.ResourcesContainer;
import de.gurkenlabs.litiengine.resources.SoundResource;
import de.gurkenlabs.litiengine.sound.Sound;
import de.gurkenlabs.litiengine.util.io.Codec;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class Sounds
extends ResourcesContainer<Sound> {
    private static final Logger log = Logger.getLogger(Sounds.class.getName());

    Sounds() {
    }

    public Sound load(SoundResource resource) {
        byte[] data = Codec.decode(resource.getData());
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        try {
            Sound sound = new Sound(input, resource.getName());
            this.add(resource.getName(), sound);
            return sound;
        }
        catch (IOException | UnsupportedAudioFileException e) {
            log.log(Level.SEVERE, "The audio file {0} could not be loaded.", new Object[]{resource.getName()});
            return null;
        }
    }

    @Override
    protected Sound load(URL resourceName) throws Exception {
        try (InputStream is = Resources.get(resourceName);){
            if (is == null) {
                log.log(Level.SEVERE, "The audio file {0} could not be loaded.", new Object[]{resourceName});
                Sound sound = null;
                return sound;
            }
            Sound sound = new Sound(is, FileUtilities.getFileName(resourceName));
            return sound;
        }
    }
}

