/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.resources;

import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.resources.ImageFormat;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.resources.ResourcesContainerClearedListener;
import de.gurkenlabs.litiengine.resources.SpritesheetResource;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import de.gurkenlabs.litiengine.util.io.Codec;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import de.gurkenlabs.litiengine.util.io.ImageSerializer;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Spritesheets {
    private final Map<String, int[]> customKeyFrameDurations = new ConcurrentHashMap<String, int[]>();
    private final Map<String, Spritesheet> loadedSpritesheets = new ConcurrentHashMap<String, Spritesheet>();
    private final Collection<ResourcesContainerClearedListener> listeners = ConcurrentHashMap.newKeySet();
    private static final Logger log = Logger.getLogger(Spritesheets.class.getName());
    private static final String SPRITE_INFO_COMMENT_CHAR = "#";

    Spritesheets() {
    }

    public void add(String name, Spritesheet spritesheet) {
        this.loadedSpritesheets.put(name, spritesheet);
    }

    public void addClearedListener(ResourcesContainerClearedListener listener) {
        this.listeners.add(listener);
    }

    public void removeClearedListener(ResourcesContainerClearedListener listener) {
        this.listeners.remove(listener);
    }

    public void clear() {
        this.loadedSpritesheets.clear();
        this.listeners.forEach(ResourcesContainerClearedListener::cleared);
    }

    public boolean contains(String name) {
        return this.loadedSpritesheets.containsKey(name);
    }

    public Spritesheet get(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        String name = FileUtilities.getFileName(path);
        return this.loadedSpritesheets.get(name);
    }

    public Collection<Spritesheet> get(Predicate<? super Spritesheet> pred) {
        if (pred == null) {
            return new ArrayList<Spritesheet>();
        }
        return this.loadedSpritesheets.values().stream().filter(pred).toList();
    }

    public Collection<Spritesheet> getAll() {
        return this.loadedSpritesheets.values();
    }

    public int[] getCustomKeyFrameDurations(String name) {
        return this.customKeyFrameDurations.getOrDefault(FileUtilities.getFileName(name), new int[0]);
    }

    public int[] getCustomKeyFrameDurations(Spritesheet sprite) {
        return this.getCustomKeyFrameDurations(sprite.getName());
    }

    public Spritesheet load(BufferedImage image, String path, int spriteWidth, int spriteHeight) {
        return new Spritesheet(image, path, spriteWidth, spriteHeight);
    }

    public Spritesheet load(ITileset tileset) {
        if (tileset == null || tileset.getImage() == null) {
            return null;
        }
        if (tileset.getImage().getAbsoluteSourcePath() == null) {
            return null;
        }
        return new Spritesheet((BufferedImage)Resources.images().get(tileset.getImage().getAbsoluteSourcePath(), true), tileset.getImage().getSource(), tileset.getTileDimension().width, tileset.getTileDimension().height);
    }

    public Spritesheet load(SpritesheetResource info) {
        if (info.getImage() == null || info.getImage().isEmpty()) {
            log.log(Level.SEVERE, "Sprite {0} could not be loaded because no image is defined.", new Object[]{info.getName()});
            return null;
        }
        String fileExtension = info.getImageFormat() == null ? "" : info.getImageFormat().toFileExtension();
        Spritesheet sprite = this.load(Codec.decodeImage(info.getImage()), info.getName() + fileExtension, info.getWidth(), info.getHeight());
        if (info.getKeyframes() != null && info.getKeyframes().length > 0) {
            this.customKeyFrameDurations.put(sprite.getName(), info.getKeyframes());
        }
        return sprite;
    }

    public List<Spritesheet> loadFrom(String spriteInfoFile) {
        ArrayList<Spritesheet> sprites = new ArrayList<Spritesheet>();
        InputStream fileStream = Resources.get(spriteInfoFile);
        if (fileStream == null) {
            return sprites;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(fileStream));){
            String line;
            while ((line = br.readLine()) != null) {
                List<String> items;
                String[] parts;
                if (line.isEmpty() || line.startsWith(SPRITE_INFO_COMMENT_CHAR) || (parts = line.split(";")).length == 0 || (items = Arrays.asList(parts[0].split("\\s*,\\s*"))).size() < 3) continue;
                this.getSpriteSheetFromSpriteInfoLine(FileUtilities.getParentDirPath(spriteInfoFile), sprites, items, parts);
            }
            log.log(Level.INFO, "{0} spritesheets loaded from {1}", new Object[]{sprites.size(), spriteInfoFile});
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return sprites;
    }

    public boolean saveTo(String spriteInfoFile, boolean metadataOnly) {
        boolean bl;
        ArrayList<Spritesheet> allSpriteSheets = new ArrayList<Spritesheet>(this.getAll());
        Collections.sort(allSpriteSheets);
        BufferedWriter writer = new BufferedWriter(new FileWriter(spriteInfoFile));
        try {
            for (Spritesheet spritesheet : allSpriteSheets) {
                int[] keyFrames = Resources.spritesheets().getCustomKeyFrameDurations(spritesheet);
                String fileExtension = spritesheet.getImageFormat() == ImageFormat.UNSUPPORTED ? "" : spritesheet.getImageFormat().toFileExtension();
                writer.write(String.format("%s%s,%d,%d", spritesheet.getName(), fileExtension, spritesheet.getSpriteWidth(), spritesheet.getSpriteHeight()));
                if (keyFrames.length > 0) {
                    writer.write(";");
                    writer.write(ArrayUtilities.join(keyFrames));
                }
                writer.write("\n");
                if (metadataOnly) continue;
                ImageSerializer.saveImage(Paths.get(new File(spriteInfoFile).getParentFile().getAbsolutePath(), spritesheet.getName() + spritesheet.getImageFormat().toFileExtension()).toString(), spritesheet.getImage(), spritesheet.getImageFormat());
            }
            String msg = metadataOnly ? "Exported Spritesheet metadata to {0}" : "Exported sprites and metadata to {0}";
            log.log(Level.INFO, msg, new Object[]{spriteInfoFile});
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                log.log(Level.SEVERE, e2.getLocalizedMessage(), e2);
                return false;
            }
        }
        writer.close();
        return bl;
    }

    public Spritesheet load(String path, int spriteWidth, int spriteHeight) {
        return new Spritesheet((BufferedImage)Resources.images().get(path, true), path, spriteWidth, spriteHeight);
    }

    public Spritesheet remove(String path) {
        Spritesheet spriteToRemove = this.loadedSpritesheets.remove(path);
        this.customKeyFrameDurations.remove(path);
        return spriteToRemove;
    }

    public Spritesheet update(SpritesheetResource info) {
        if (info == null || info.getName() == null) {
            return null;
        }
        Spritesheet spriteToRemove = this.remove(info.getName());
        if (spriteToRemove != null) {
            this.customKeyFrameDurations.remove(info.getName());
            if (info.getHeight() == 0 && info.getWidth() == 0) {
                return null;
            }
            return this.load(info);
        }
        return null;
    }

    private void getSpriteSheetFromSpriteInfoLine(String baseDirectory, ArrayList<Spritesheet> sprites, List<String> items, String[] parts) {
        try {
            String name = baseDirectory + items.get(0);
            int width = Integer.parseInt(items.get(1));
            int height = Integer.parseInt(items.get(2));
            Spritesheet sprite = this.load(name, width, height);
            sprites.add(sprite);
            if (parts.length >= 2) {
                List<String> keyFrameStrings = Arrays.asList(parts[1].split("\\s*,\\s*"));
                this.customKeyFrameDurations.put(sprite.getName(), keyFrameStrings.stream().mapToInt(Integer::parseInt).toArray());
            }
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

