/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ArrayUtilities {
    public static final String DEFAULT_STRING_DELIMITER = ",";
    private static final Logger log = Logger.getLogger(ArrayUtilities.class.getName());

    private ArrayUtilities() {
        throw new UnsupportedOperationException();
    }

    public static byte[] concat(byte[] first, byte[] second) {
        byte[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static int[] concat(int[] first, int[] second) {
        int[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static long[] concat(long[] first, long[] second) {
        long[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static double[] concat(double[] first, double[] second) {
        double[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static int[] splitInt(String delimiterSeparatedString) {
        return ArrayUtilities.splitInt(delimiterSeparatedString, DEFAULT_STRING_DELIMITER);
    }

    public static int[] splitInt(String delimiterSeparatedString, String delimiter) {
        if (delimiterSeparatedString == null || delimiterSeparatedString.isEmpty()) {
            return new int[0];
        }
        String[] split = delimiterSeparatedString.split(delimiter);
        int[] integers = new int[split.length];
        if (integers.length == 0) {
            return integers;
        }
        for (int i = 0; i < split.length; ++i) {
            if (split[i] == null || split[i].isEmpty()) continue;
            try {
                integers[i] = Integer.parseInt(split[i]);
                continue;
            }
            catch (NumberFormatException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return integers;
    }

    public static double[] splitDouble(String delimiterSeparatedString) {
        return ArrayUtilities.splitDouble(delimiterSeparatedString, DEFAULT_STRING_DELIMITER);
    }

    public static double[] splitDouble(String delimiterSeparatedString, String delimiter) {
        if (delimiterSeparatedString == null || delimiterSeparatedString.isEmpty()) {
            return new double[0];
        }
        String[] split = delimiterSeparatedString.split(delimiter);
        double[] doubles = new double[split.length];
        if (doubles.length == 0) {
            return doubles;
        }
        for (int i = 0; i < split.length; ++i) {
            if (split[i] == null || split[i].isEmpty()) continue;
            try {
                doubles[i] = Double.parseDouble(split[i]);
                continue;
            }
            catch (NumberFormatException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return doubles;
    }

    public static String join(boolean[] arr) {
        return ArrayUtilities.joinArray(arr, DEFAULT_STRING_DELIMITER);
    }

    public static String join(boolean[] arr, String delimiter) {
        return ArrayUtilities.joinArray(arr, delimiter);
    }

    public static String join(int[] arr) {
        return ArrayUtilities.joinArray(arr, DEFAULT_STRING_DELIMITER);
    }

    public static String join(int[] arr, String delimiter) {
        return ArrayUtilities.joinArray(arr, delimiter);
    }

    public static String join(double[] arr) {
        return ArrayUtilities.joinArray(arr, DEFAULT_STRING_DELIMITER);
    }

    public static String join(double[] arr, String delimiter) {
        return ArrayUtilities.joinArray(arr, delimiter);
    }

    public static String join(float[] arr) {
        return ArrayUtilities.joinArray(arr, DEFAULT_STRING_DELIMITER);
    }

    public static String join(float[] arr, String delimiter) {
        return ArrayUtilities.joinArray(arr, delimiter);
    }

    public static String join(short[] arr) {
        return ArrayUtilities.joinArray(arr, DEFAULT_STRING_DELIMITER);
    }

    public static String join(short[] arr, String delimiter) {
        return ArrayUtilities.joinArray(arr, delimiter);
    }

    public static String join(long[] arr) {
        return ArrayUtilities.join(arr, DEFAULT_STRING_DELIMITER);
    }

    public static String join(long[] arr, String delimiter) {
        return ArrayUtilities.joinArray(arr, delimiter);
    }

    public static String join(byte[] arr) {
        return ArrayUtilities.join(arr, DEFAULT_STRING_DELIMITER);
    }

    public static String join(byte[] arr, String delimiter) {
        return ArrayUtilities.joinArray(arr, delimiter);
    }

    public static String join(Collection<?> collection) {
        return ArrayUtilities.joinArray(collection.toArray(), DEFAULT_STRING_DELIMITER);
    }

    public static String join(Collection<?> collection, String delimiter) {
        return ArrayUtilities.joinArray(collection.toArray(), delimiter);
    }

    public static String join(Object[] arr) {
        return ArrayUtilities.joinArray(arr, DEFAULT_STRING_DELIMITER);
    }

    public static String join(Object[] arr, String delimiter) {
        return ArrayUtilities.joinArray(arr, delimiter);
    }

    public static <T> List<T> toList(T[][] arr) {
        ArrayList<T> list = new ArrayList<T>();
        for (T[] rows : arr) {
            list.addAll(Arrays.asList(rows));
        }
        return list;
    }

    public static boolean contains(Object[] arr, Object value) {
        for (Object v : arr) {
            if (value == null && v == null) {
                return true;
            }
            if (v == null || !v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String[] arr, String argument, boolean ignoreCase) {
        if (arr == null) {
            return false;
        }
        for (String arg : arr) {
            if (arg == null || arg.isEmpty() || (!ignoreCase || !arg.equalsIgnoreCase(argument)) && (ignoreCase || !arg.equals(argument))) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] remove(T[] input, T deleteItem) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : input) {
            if (deleteItem.equals(item)) continue;
            result.add(item);
        }
        result.removeAll(Collections.singleton(null));
        return result.toArray((Object[])Array.newInstance(input.getClass().getComponentType(), result.size()));
    }

    public static <T> T[] append(T[] input, T addItem) {
        ArrayList<Object> result = new ArrayList<Object>(Arrays.asList(input));
        result.add(addItem);
        return result.toArray((Object[])Array.newInstance(input.getClass().getComponentType(), result.size()));
    }

    public static <T> T[] distinct(T[] first, T[] second) {
        List<T> firstList = Arrays.asList(first);
        List<T> secondList = Arrays.asList(second);
        HashSet<Object> hash = new HashSet<Object>(firstList);
        hash.addAll(secondList);
        return hash.toArray((Object[])Array.newInstance(first.getClass().getComponentType(), hash.size()));
    }

    public static <T> T[] arrayCopy(T[] original) {
        return (Object[])original.clone();
    }

    public static int[] toIntegerArray(List<Integer> intList) {
        Integer[] objArray = intList.toArray(new Integer[0]);
        int[] intArray = new int[objArray.length];
        System.arraycopy(objArray, 0, intArray, 0, objArray.length);
        return intArray;
    }

    private static String joinArray(Object arr, String separator) {
        if (arr == null) {
            return null;
        }
        int len = Array.getLength(arr);
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(String.valueOf(Array.get(arr, 0)));
        for (int i = 1; i < len; ++i) {
            sb.append(separator);
            sb.append(Array.get(arr, i));
        }
        return sb.toString();
    }
}

