/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ColorHelper {
    private static final Logger log = Logger.getLogger(ColorHelper.class.getName());
    private static final int HEX_STRING_LENGTH = 7;
    private static final int HEX_STRING_LENGTH_ALPHA = 9;
    private static final int MAX_RGB_VALUE = 255;

    private ColorHelper() {
        throw new UnsupportedOperationException();
    }

    public static String encode(Color color) {
        if (color == null) {
            return null;
        }
        String colorString = String.format("%08x", color.getRGB());
        if (color.getAlpha() == 255) {
            return "#" + colorString.substring(2);
        }
        return "#" + colorString;
    }

    public static Color decode(String colorHexString) {
        return ColorHelper.decode(colorHexString, false);
    }

    public static Color decode(String colorHexString, boolean solid) {
        if (colorHexString == null || ((String)colorHexString).isEmpty()) {
            return null;
        }
        if (!((String)colorHexString).startsWith("#")) {
            if (((String)colorHexString).length() == 6 || ((String)colorHexString).length() == 8) {
                colorHexString = "#" + (String)colorHexString;
            } else {
                log.log(Level.SEVERE, "Could not parse color string \"{0}\". A color string needs to start with a \"#\" character.", colorHexString);
                return null;
            }
        }
        return switch (((String)colorHexString).length()) {
            case 7 -> ColorHelper.decodeWellformedHexString((String)colorHexString);
            case 9 -> ColorHelper.decodeHexStringWithAlpha((String)colorHexString, solid);
            default -> {
                log.log(Level.SEVERE, "Could not parse color string \"{0}\". Invalid string length \"{1}\"!\nAccepted lengths:\n\t{2} for Colors without Alpha (#ff0000)\n\t{3} for Colors with Alpha (#c8ff0000)", new Object[]{colorHexString, ((String)colorHexString).length(), 7, 9});
                yield null;
            }
        };
    }

    public static int ensureColorValueRange(float value) {
        return ColorHelper.ensureColorValueRange(Math.round(value));
    }

    public static int ensureColorValueRange(int value) {
        return Math.clamp((long)value, 0, 255);
    }

    public static Color premultiply(Color color) {
        if (color.getAlpha() == 255) {
            return color;
        }
        return new Color(ColorHelper.premultiply(color.getRed(), color.getAlpha()), ColorHelper.premultiply(color.getGreen(), color.getAlpha()), ColorHelper.premultiply(color.getBlue(), color.getAlpha()));
    }

    public static Color interpolate(Color color1, Color color2, double factor) {
        factor = Math.clamp(factor, 0.0, 1.0);
        int r = (int)((double)color1.getRed() * (1.0 - factor) + (double)color2.getRed() * factor);
        int g = (int)((double)color1.getGreen() * (1.0 - factor) + (double)color2.getGreen() * factor);
        int b = (int)((double)color1.getBlue() * (1.0 - factor) + (double)color2.getBlue() * factor);
        int a = (int)((double)color1.getAlpha() * (1.0 - factor) + (double)color2.getAlpha() * factor);
        return new Color(r, g, b, a);
    }

    public static Color getTransparentVariant(Color color, int newAlpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), ColorHelper.ensureColorValueRange(newAlpha));
    }

    private static Color decodeWellformedHexString(String hexString) {
        try {
            return Color.decode(hexString);
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private static int premultiply(int value, int alpha) {
        return (int)Math.round((double)value * Math.pow((double)alpha / 255.0, 0.45454545454545453));
    }

    private static Color decodeHexStringWithAlpha(String hexString, boolean solid) {
        int alphaValue;
        String alpha = hexString.substring(1, 3);
        try {
            alphaValue = ColorHelper.ensureColorValueRange(Integer.parseInt(alpha, 16));
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        StringBuilder sb = new StringBuilder(hexString);
        sb.replace(1, 3, "");
        String baseColorString = sb.toString();
        Color baseColor = ColorHelper.decodeWellformedHexString(baseColorString);
        if (baseColor == null) {
            return null;
        }
        baseColor = new Color(baseColor.getRGB() & 0xFFFFFF | alphaValue << 24, true);
        if (solid) {
            return ColorHelper.premultiply(baseColor);
        }
        return baseColor;
    }
}

