/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util;

import de.gurkenlabs.litiengine.entities.Material;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ReflectionUtilities {
    private static final Logger log = Logger.getLogger(ReflectionUtilities.class.getName());

    private ReflectionUtilities() {
        throw new UnsupportedOperationException();
    }

    public static <T> Field getField(Class<T> cls, String fieldName) {
        return ReflectionUtilities.getField(cls, fieldName, true);
    }

    public static <T> Field getField(Class<T> cls, String fieldName, boolean recursive) {
        Field f;
        for (Field field : cls.getDeclaredFields()) {
            if (!field.getName().equalsIgnoreCase(fieldName)) continue;
            return field;
        }
        if (recursive && cls.getSuperclass() != null && !cls.getSuperclass().equals(Object.class) && (f = ReflectionUtilities.getField(cls.getSuperclass(), fieldName, true)) != null) {
            return f;
        }
        log.log(Level.WARNING, "Could not find field [{0}] on class [{1}] or its parents.", new Object[]{fieldName, cls});
        return null;
    }

    public static <V> V getStaticValue(Class<?> cls, String fieldName) {
        Field keyField = ReflectionUtilities.getField(cls, fieldName);
        if (keyField == null) {
            return null;
        }
        try {
            return (V)keyField.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null && !type.getSuperclass().equals(Object.class)) {
            ReflectionUtilities.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    public static Method getMethod(String name, Class<?> type, Class<?> ... parameterTypes) {
        Method method;
        block2: {
            method = null;
            try {
                method = type.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                if (type.getSuperclass() == null || type.getSuperclass().equals(Object.class)) break block2;
                return ReflectionUtilities.getMethod(name, type.getSuperclass(), parameterTypes);
            }
        }
        return method;
    }

    public static <T, C> boolean setValue(Class<C> cls, Object instance, String fieldName, T value) {
        try {
            Method method = ReflectionUtilities.getSetter(cls, fieldName);
            if (method != null) {
                if (!method.canAccess(instance)) {
                    method.setAccessible(true);
                }
                method.invoke(instance, value);
                return true;
            }
            for (Field field : cls.getDeclaredFields()) {
                if (!field.getName().equals(fieldName) || field.getType() != value.getClass() && !ReflectionUtilities.isWrapperType(field.getType(), value.getClass()) && !ReflectionUtilities.isWrapperType(value.getClass(), field.getType())) continue;
                if (!field.canAccess(instance)) {
                    field.setAccessible(true);
                }
                field.set(instance, value);
                return true;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            log.log(Level.SEVERE, String.format("%s (%s-%s)", e.getMessage(), fieldName, value), e);
        }
        return false;
    }

    public static <T> boolean setEnumPropertyValue(Class<T> cls, Object instance, Field field, String propertyName, String value) {
        ?[] enumArray;
        for (Object enumConst : enumArray = field.getType().getEnumConstants()) {
            if (enumConst == null || !enumConst.toString().equalsIgnoreCase(value)) continue;
            return ReflectionUtilities.setValue(cls, instance, propertyName, field.getType().cast(enumConst));
        }
        return false;
    }

    public static <T> Method getSetter(Class<T> cls, String fieldName) {
        for (Method method : ReflectionUtilities.getSetters(cls)) {
            if (!method.getName().equalsIgnoreCase("set" + fieldName)) continue;
            return method;
        }
        return null;
    }

    public static <T> Collection<Method> getSetters(Class<T> cls) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : cls.getMethods()) {
            if (!method.getName().toLowerCase().startsWith("set") || method.getParameters().length != 1) continue;
            methods.add(method);
        }
        return Collections.unmodifiableCollection(methods);
    }

    public static <T, C> boolean isWrapperType(Class<T> primitive, Class<C> potentialWrapper) {
        if (!primitive.isPrimitive() || potentialWrapper.isPrimitive()) {
            return false;
        }
        if (primitive == Boolean.TYPE) {
            return potentialWrapper == Boolean.class;
        }
        if (primitive == Character.TYPE) {
            return potentialWrapper == Character.class;
        }
        if (primitive == Byte.TYPE) {
            return potentialWrapper == Byte.class;
        }
        if (primitive == Short.TYPE) {
            return potentialWrapper == Short.class;
        }
        if (primitive == Integer.TYPE) {
            return potentialWrapper == Integer.class;
        }
        if (primitive == Long.TYPE) {
            return potentialWrapper == Long.class;
        }
        if (primitive == Float.TYPE) {
            return potentialWrapper == Float.class;
        }
        if (primitive == Double.TYPE) {
            return potentialWrapper == Double.class;
        }
        if (primitive == Void.TYPE) {
            return potentialWrapper == Void.class;
        }
        return false;
    }

    public static <T> boolean setFieldValue(Class<T> cls, Object instance, String fieldName, String value) {
        Field field = ReflectionUtilities.getField(cls, fieldName);
        if (field == null) {
            return false;
        }
        if (Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        try {
            if (field.getType().equals(Boolean.TYPE)) {
                return ReflectionUtilities.setValue(cls, instance, fieldName, Boolean.parseBoolean(value));
            }
            if (field.getType().equals(Integer.TYPE)) {
                return ReflectionUtilities.setValue(cls, instance, fieldName, Integer.parseInt(value));
            }
            if (field.getType().equals(Float.TYPE)) {
                return ReflectionUtilities.setValue(cls, instance, fieldName, Float.valueOf(Float.parseFloat(value)));
            }
            if (field.getType().equals(Double.TYPE)) {
                return ReflectionUtilities.setValue(cls, instance, fieldName, Double.parseDouble(value));
            }
            if (field.getType().equals(Short.TYPE)) {
                return ReflectionUtilities.setValue(cls, instance, fieldName, Short.parseShort(value));
            }
            if (field.getType().equals(Byte.TYPE)) {
                return ReflectionUtilities.setValue(cls, instance, fieldName, Byte.parseByte(value));
            }
            if (field.getType().equals(Long.TYPE)) {
                return ReflectionUtilities.setValue(cls, instance, fieldName, Long.parseLong(value));
            }
            if (field.getType().equals(String.class)) {
                return ReflectionUtilities.setValue(cls, instance, fieldName, value);
            }
            if (field.getType().equals(String[].class)) {
                return ReflectionUtilities.setValue(cls, instance, fieldName, value.split(","));
            }
            if (field.getType().equals(int[].class)) {
                return ReflectionUtilities.setValue(cls, instance, fieldName, ArrayUtilities.splitInt(value, ","));
            }
            if (field.getType().equals(double[].class)) {
                return ReflectionUtilities.setValue(cls, instance, fieldName, ArrayUtilities.splitDouble(value, ","));
            }
            if (field.getType().isEnum()) {
                return ReflectionUtilities.setEnumPropertyValue(cls, instance, field, fieldName, value);
            }
            if (field.getType().equals(Material.class)) {
                return ReflectionUtilities.setValue(cls, instance, fieldName, Material.get(value));
            }
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return false;
    }

    public static List<Method> getMethodsAnnotatedWith(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> clazz = type; clazz != Object.class; clazz = clazz.getSuperclass()) {
            ArrayList<Method> allMethods = new ArrayList<Method>(Arrays.asList(clazz.getDeclaredMethods()));
            for (Method method : allMethods) {
                if (!method.isAnnotationPresent(annotation)) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public static Collection<Method> getEvents(Class<?> type) {
        String eventAddPrefix = "add";
        String eventOnPrefix = "on";
        ArrayList<Method> events = new ArrayList<Method>();
        for (Class<?> clazz = type; clazz != Object.class; clazz = clazz.getSuperclass()) {
            ArrayList<Method> allMethods = new ArrayList<Method>(Arrays.asList(clazz.getDeclaredMethods()));
            for (Method method : allMethods) {
                for (Class<?> paramtype : method.getParameterTypes()) {
                    if (!EventListener.class.isAssignableFrom(paramtype) || !method.getName().startsWith("add") && !method.getName().startsWith("on")) continue;
                    events.add(method);
                }
            }
        }
        return events;
    }

    public static <T> T getDefaultValue(Class<T> clazz) {
        return (T)Array.get(Array.newInstance(clazz, 1), 0);
    }
}

