/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util.io;

import de.gurkenlabs.litiengine.resources.ImageFormat;
import de.gurkenlabs.litiengine.util.Imaging;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public final class Codec {
    private static final Logger log = Logger.getLogger(Codec.class.getName());

    private Codec() {
        throw new UnsupportedOperationException();
    }

    public static float decodeAngle(byte encodedAngle) {
        float angle = encodedAngle;
        angle += 127.0f;
        angle /= 0.7111111f;
        return (angle += 360.0f) % 360.0f;
    }

    public static float decodeAngle(short encodedAngle) {
        return Codec.decodeSmallFloatingPointNumber(encodedAngle, 2);
    }

    public static float decodeSmallFloatingPointNumber(short encodedNumber, int precision) {
        return (float)((double)(encodedNumber + Short.MAX_VALUE) / Math.pow(10.0, precision));
    }

    public static byte encodeAngle(float angle) {
        float encodedAngle = angle % 360.0f;
        encodedAngle *= 0.7111111f;
        return (byte)(encodedAngle -= 127.0f);
    }

    public static short encodeAnglePrecise(float angle) {
        float encodedAngle = angle;
        if (encodedAngle < 0.0f) {
            encodedAngle += 360.0f;
        }
        return Codec.encodeSmallFloatingPointNumber(encodedAngle %= 360.0f, 2);
    }

    public static short encodeSmallFloatingPointNumber(float smallNumber, int precision) {
        if (smallNumber < 0.0f || (int)((double)smallNumber * Math.pow(10.0, precision)) > 65534) {
            throw new IllegalArgumentException("The specified number is not within the range to encode.");
        }
        return (short)((double)smallNumber * Math.pow(10.0, precision) - 32767.0);
    }

    public static BufferedImage decodeImage(String imageString) {
        if (imageString == null) {
            return null;
        }
        BufferedImage image = null;
        try {
            byte[] imageByte = Codec.decode(imageString);
            ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
            image = ImageIO.read(bis);
            bis.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return Imaging.toCompatibleImage(image);
    }

    public static String encode(BufferedImage image) {
        return Codec.encode(image, ImageFormat.PNG);
    }

    public static String encode(BufferedImage image, ImageFormat imageFormat) {
        if (image == null) {
            return null;
        }
        String imageString = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, imageFormat != ImageFormat.UNSUPPORTED ? imageFormat.toString() : ImageFormat.PNG.toString(), bos);
            byte[] imageBytes = bos.toByteArray();
            imageString = Codec.encode(imageBytes);
            bos.close();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return imageString;
    }

    public static String encode(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static byte[] decode(String base64) {
        return Base64.getDecoder().decode(base64);
    }
}

