/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.junique;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Message {
    Message() {
    }

    public static String read(InputStream inputStream) throws IOException {
        byte[] b = new byte[4];
        if (inputStream.read(b) != 4) {
            throw new IOException("Unexpected end of stream");
        }
        int length = Message.byteArrayToInt(b);
        if (length < 0) {
            throw new IOException("Invalid length block");
        }
        if (length == 0) {
            return "";
        }
        byte[] message = new byte[length];
        if (inputStream.read(message) != length) {
            throw new IOException("Unexpected end of stream");
        }
        return new String(message, "UTF-8");
    }

    public static void write(String message, OutputStream outputStream) throws IOException {
        if (message == null) {
            outputStream.write(0);
            outputStream.write(0);
            outputStream.write(0);
            outputStream.write(0);
            outputStream.flush();
        } else {
            int length = message.length();
            byte[] lenght = Message.intToByteArray(length);
            outputStream.write(lenght);
            outputStream.flush();
            byte[] b = message.getBytes("UTF-8");
            outputStream.write(b);
            outputStream.flush();
        }
    }

    private static byte[] intToByteArray(int value) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (3 - i) * 8;
            b[i] = (byte)(value >> offset & 0xFF);
        }
        return b;
    }

    private static int byteArrayToInt(byte[] b) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i] & 0xFF) << shift;
        }
        return value;
    }
}

