/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.eventsource;

import de.huxhorn.lilith.data.eventsource.EventIdentifier;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import java.io.Serializable;

public class EventWrapper<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 6302031645772429174L;
    private EventIdentifier eventIdentifier;
    private T event;

    public EventWrapper() {
        this(null, -1L, null);
    }

    public EventWrapper(SourceIdentifier sourceIdentifier, long localId, T event) {
        this(new EventIdentifier(sourceIdentifier, localId), event);
    }

    public EventWrapper(EventIdentifier eventIdentifier, T event) {
        this.eventIdentifier = eventIdentifier;
        this.event = event;
    }

    public SourceIdentifier getSourceIdentifier() {
        if (this.eventIdentifier != null) {
            return this.eventIdentifier.getSourceIdentifier();
        }
        return null;
    }

    public void setSourceIdentifier(SourceIdentifier sourceIdentifier) {
        if (this.eventIdentifier == null) {
            this.eventIdentifier = new EventIdentifier();
        }
        this.eventIdentifier.setSourceIdentifier(sourceIdentifier);
    }

    public long getLocalId() {
        if (this.eventIdentifier != null) {
            return this.eventIdentifier.getLocalId();
        }
        return -1L;
    }

    public void setLocalId(long localId) {
        if (this.eventIdentifier == null) {
            this.eventIdentifier = new EventIdentifier();
        }
        this.eventIdentifier.setLocalId(localId);
    }

    public EventIdentifier getEventIdentifier() {
        return this.eventIdentifier;
    }

    public void setEventIdentifier(EventIdentifier eventIdentifier) {
        this.eventIdentifier = eventIdentifier;
    }

    public T getEvent() {
        return this.event;
    }

    public void setEvent(T event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventWrapper that = (EventWrapper)o;
        if (this.eventIdentifier != null ? !this.eventIdentifier.equals(that.eventIdentifier) : that.eventIdentifier != null) {
            return false;
        }
        return !(this.event == null ? that.event != null : !this.event.equals(that.event));
    }

    public int hashCode() {
        if (this.eventIdentifier != null) {
            return this.eventIdentifier.hashCode();
        }
        return this.event != null ? this.event.hashCode() : 0;
    }

    public String toString() {
        return "EventWrapper{eventIdentifier=" + this.eventIdentifier + ", event=" + this.event + '}';
    }
}

