/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.protobuf;

import de.huxhorn.lilith.data.eventsource.LoggerContext;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.ThreadInfo;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import de.huxhorn.lilith.data.logging.protobuf.generated.LoggingProto;
import de.huxhorn.sulky.codec.Encoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class LoggingEventProtobufEncoder
implements Encoder<LoggingEvent> {
    private final boolean compressing;

    LoggingEventProtobufEncoder(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    /*
     * Exception decompiling
     */
    public byte[] encode(LoggingEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static LoggingProto.Marker convert(Marker marker) {
        if (marker == null) {
            return null;
        }
        ArrayList<String> handledMarkers = new ArrayList<String>();
        return LoggingEventProtobufEncoder.convert(marker, handledMarkers);
    }

    private static LoggingProto.Marker convert(Marker marker, List<String> handledMarkers) {
        String markerName = marker.getName();
        LoggingProto.Marker.Builder builder = LoggingProto.Marker.newBuilder().setName(markerName);
        if (handledMarkers.contains(markerName)) {
            return builder.build();
        }
        handledMarkers.add(markerName);
        boolean hasReferences = marker.hasReferences();
        if (hasReferences) {
            Map refs = marker.getReferences();
            for (Map.Entry current : refs.entrySet()) {
                builder.addReference(LoggingEventProtobufEncoder.convert((Marker)current.getValue(), handledMarkers));
            }
        }
        return builder.build();
    }

    public static LoggingProto.StackTraceElement convert(ExtendedStackTraceElement ste) {
        String version;
        String fileName;
        String className;
        String methodName;
        String moduleVersion;
        String moduleName;
        if (ste == null) {
            return null;
        }
        LoggingProto.StackTraceElement.Builder builder = LoggingProto.StackTraceElement.newBuilder();
        String classLoaderName = ste.getClassLoaderName();
        if (classLoaderName != null) {
            builder.setClassLoaderName(classLoaderName);
        }
        if ((moduleName = ste.getModuleName()) != null) {
            builder.setModuleName(moduleName);
        }
        if ((moduleVersion = ste.getModuleVersion()) != null) {
            builder.setModuleVersion(moduleVersion);
        }
        if ((methodName = ste.getMethodName()) != null) {
            builder.setMethodName(methodName);
        }
        if ((className = ste.getClassName()) != null) {
            builder.setClassName(className);
        }
        if ((fileName = ste.getFileName()) != null) {
            builder.setFileName(fileName);
        }
        int lineNumber = ste.getLineNumber();
        builder.setLineNumber(lineNumber);
        String codeLocation = ste.getCodeLocation();
        if (codeLocation != null) {
            builder.setCodeLocation(codeLocation);
        }
        if ((version = ste.getVersion()) != null) {
            builder.setVersion(version);
        }
        builder.setExact(ste.isExact());
        return builder.build();
    }

    public static LoggingProto.Throwable convert(ThrowableInfo throwableInfo) {
        ExtendedStackTraceElement[] stackTrace;
        ThrowableInfo cause;
        ThrowableInfo[] suppressed;
        int omittedElements;
        String message;
        if (throwableInfo == null) {
            return null;
        }
        LoggingProto.Throwable.Builder builder = LoggingProto.Throwable.newBuilder();
        String name = throwableInfo.getName();
        if (name != null) {
            builder.setThrowableClass(name);
        }
        if ((message = throwableInfo.getMessage()) != null) {
            builder.setMessage(message);
        }
        if ((omittedElements = throwableInfo.getOmittedElements()) > 0) {
            builder.setOmittedElements(omittedElements);
        }
        if ((suppressed = throwableInfo.getSuppressed()) != null) {
            for (ThrowableInfo throwableInfo2 : suppressed) {
                if (throwableInfo2 == null) continue;
                builder.addSuppressed(LoggingEventProtobufEncoder.convert(throwableInfo2));
            }
        }
        if ((cause = throwableInfo.getCause()) != null) {
            builder.setCause(LoggingEventProtobufEncoder.convert(cause));
        }
        if ((stackTrace = throwableInfo.getStackTrace()) != null) {
            for (ThrowableInfo throwableInfo3 : stackTrace) {
                if (throwableInfo3 == null) continue;
                builder.addStackTraceElement(LoggingEventProtobufEncoder.convert((ExtendedStackTraceElement)throwableInfo3));
            }
        }
        return builder.build();
    }

    public static LoggingProto.Message convert(Message message) {
        String[] arguments;
        if (message == null) {
            return null;
        }
        LoggingProto.Message.Builder messageBuilder = LoggingProto.Message.newBuilder();
        String pattern = message.getMessagePattern();
        if (pattern != null) {
            messageBuilder.setMessagePattern(pattern);
        }
        if ((arguments = message.getArguments()) != null) {
            for (String current : arguments) {
                LoggingProto.MessageArgument.Builder argumentBuilder = LoggingProto.MessageArgument.newBuilder();
                if (current != null) {
                    argumentBuilder.setValue(current);
                }
                messageBuilder.addArgument(argumentBuilder.build());
            }
        }
        return messageBuilder.build();
    }

    public static LoggingProto.ThreadInfo convert(ThreadInfo threadInfo) {
        Integer priority;
        Long id;
        if (threadInfo == null) {
            return null;
        }
        LoggingProto.ThreadInfo.Builder builder = LoggingProto.ThreadInfo.newBuilder();
        String name = threadInfo.getName();
        if (name != null) {
            builder.setName(name);
        }
        if ((id = threadInfo.getId()) != null) {
            builder.setId(id);
        }
        if ((name = threadInfo.getGroupName()) != null) {
            builder.setGroupName(name);
        }
        if ((id = threadInfo.getGroupId()) != null) {
            builder.setGroupId(id);
        }
        if ((priority = threadInfo.getPriority()) != null) {
            builder.setPriority(priority);
        }
        return builder.build();
    }

    public static LoggingProto.LoggerContext convert(LoggerContext context) {
        Map map;
        Long birthTime;
        if (context == null) {
            return null;
        }
        LoggingProto.LoggerContext.Builder builder = LoggingProto.LoggerContext.newBuilder();
        String name = context.getName();
        if (name != null) {
            builder.setName(name);
        }
        if ((birthTime = context.getBirthTime()) != null) {
            builder.setBirthTime(birthTime);
        }
        if ((map = context.getProperties()) != null && !map.isEmpty()) {
            builder.setProperties(LoggingEventProtobufEncoder.convert(map));
        }
        return builder.build();
    }

    public static LoggingProto.StringMap convert(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        LoggingProto.StringMap.Builder builder = LoggingProto.StringMap.newBuilder();
        for (Map.Entry<String, String> current : map.entrySet()) {
            LoggingProto.StringMapEntry.Builder entryBuilder = LoggingProto.StringMapEntry.newBuilder().setKey(current.getKey());
            String value = current.getValue();
            if (value != null) {
                entryBuilder.setValue(value);
            }
            builder.addEntry(entryBuilder.build());
        }
        return builder.build();
    }

    public static LoggingProto.LoggingEvent convert(LoggingEvent event) {
        Message[] ndc;
        Map mdc;
        Message message;
        Long timeStamp;
        ExtendedStackTraceElement[] callStack;
        Marker marker;
        ThrowableInfo throwable;
        LoggerContext context;
        LoggingEvent.Level level;
        ThreadInfo threadInfo;
        Long sequence;
        if (event == null) {
            return null;
        }
        LoggingProto.LoggingEvent.Builder eventBuilder = LoggingProto.LoggingEvent.newBuilder();
        String loggerName = event.getLogger();
        if (loggerName != null) {
            eventBuilder.setLoggerName(loggerName);
        }
        if ((sequence = event.getSequenceNumber()) != null) {
            eventBuilder.setSequenceNumber(sequence);
        }
        if ((threadInfo = event.getThreadInfo()) != null) {
            eventBuilder.setThreadInfo(LoggingEventProtobufEncoder.convert(threadInfo));
        }
        if ((level = event.getLevel()) != null) {
            switch (level) {
                case TRACE: {
                    eventBuilder.setLevel(LoggingProto.Level.TRACE);
                    break;
                }
                case DEBUG: {
                    eventBuilder.setLevel(LoggingProto.Level.DEBUG);
                    break;
                }
                case INFO: {
                    eventBuilder.setLevel(LoggingProto.Level.INFO);
                    break;
                }
                case WARN: {
                    eventBuilder.setLevel(LoggingProto.Level.WARN);
                    break;
                }
                default: {
                    eventBuilder.setLevel(LoggingProto.Level.ERROR);
                }
            }
        }
        if ((context = event.getLoggerContext()) != null) {
            eventBuilder.setLoggerContext(LoggingEventProtobufEncoder.convert(context));
        }
        if ((throwable = event.getThrowable()) != null) {
            eventBuilder.setThrowable(LoggingEventProtobufEncoder.convert(throwable));
        }
        if ((marker = event.getMarker()) != null) {
            eventBuilder.setMarker(LoggingEventProtobufEncoder.convert(marker));
        }
        if ((callStack = event.getCallStack()) != null) {
            for (ExtendedStackTraceElement current : callStack) {
                if (current == null) continue;
                eventBuilder.addCallStackElement(LoggingEventProtobufEncoder.convert(current));
            }
        }
        if ((timeStamp = event.getTimeStamp()) != null) {
            eventBuilder.setTimeStamp(timeStamp);
        }
        if ((message = event.getMessage()) != null) {
            eventBuilder.setMessage(LoggingEventProtobufEncoder.convert(message));
        }
        if ((mdc = event.getMdc()) != null && !mdc.isEmpty()) {
            eventBuilder.setMappedDiagnosticContext(LoggingEventProtobufEncoder.convert(mdc));
        }
        if ((ndc = event.getNdc()) != null && ndc.length > 0) {
            LoggingProto.NestedDiagnosticContext.Builder ndcBuilder = LoggingProto.NestedDiagnosticContext.newBuilder();
            for (Message currentMessage : ndc) {
                ndcBuilder.addEntry(LoggingEventProtobufEncoder.convert(currentMessage));
            }
            eventBuilder.setNestedDiagnosticContext(ndcBuilder.build());
        }
        return eventBuilder.build();
    }
}

