/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;

public class ExtendedStackTraceElement
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6954579590347369344L;
    public static final ExtendedStackTraceElement[] ARRAY_PROTOTYPE = new ExtendedStackTraceElement[0];
    public static final int UNKNOWN_SOURCE_LINE_NUMBER = -1;
    public static final int NATIVE_METHOD_LINE_NUMBER = -2;
    private static final String NATIVE_METHOD_STRING = "Native Method";
    private static final String UNKNOWN_SOURCE_STRING = "Unknown Source";
    private static final String NA_PLACEHOLDER = "na";
    private static final String EXTENDED_EXACT_PREFIX = "[";
    private static final String EXTENDED_INEXACT_PREFIX = "~[";
    private static final String EXTENDED_POSTFIX = "]";
    private static final char SEPARATOR_CHAR = ':';
    private static final char MODULE_SEPARATOR_CHAR = '/';
    private static final char MODULE_VERSION_SEPARATOR_CHAR = '@';
    private static final Method GET_CLASS_LOADER_NAME;
    private static final Method GET_MODULE_NAME;
    private static final Method GET_MODULE_VERSION;
    private static final Constructor<StackTraceElement> FULL_CTOR;
    private String className;
    private String methodName;
    private String fileName;
    private int lineNumber;
    private String codeLocation;
    private String version;
    private boolean exact;
    private String classLoaderName;
    private String moduleName;
    private String moduleVersion;

    public ExtendedStackTraceElement() {
        this.lineNumber = -1;
    }

    public ExtendedStackTraceElement(StackTraceElement stackTraceElement) {
        Objects.requireNonNull(stackTraceElement, "stackTraceElement must not be null!");
        this.className = stackTraceElement.getClassName();
        this.methodName = stackTraceElement.getMethodName();
        this.fileName = stackTraceElement.getFileName();
        this.lineNumber = stackTraceElement.getLineNumber();
        this.classLoaderName = ExtendedStackTraceElement.getClassLoaderNameFrom(stackTraceElement);
        this.moduleName = ExtendedStackTraceElement.getModuleNameFrom(stackTraceElement);
        this.moduleVersion = ExtendedStackTraceElement.getModuleVersionFrom(stackTraceElement);
    }

    public ExtendedStackTraceElement(String className, String methodName, String fileName, int lineNumber) {
        this(className, methodName, fileName, lineNumber, null, null, false);
    }

    public ExtendedStackTraceElement(String className, String methodName, String fileName, int lineNumber, String codeLocation, String version, boolean exact) {
        this.className = className;
        this.methodName = methodName;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.codeLocation = codeLocation;
        this.version = version;
        this.exact = exact;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getCodeLocation() {
        return this.codeLocation;
    }

    public void setCodeLocation(String codeLocation) {
        this.codeLocation = codeLocation;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isExact() {
        return this.exact;
    }

    public void setExact(boolean exact) {
        this.exact = exact;
    }

    public String getClassLoaderName() {
        return this.classLoaderName;
    }

    public void setClassLoaderName(String classLoaderName) {
        this.classLoaderName = classLoaderName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleVersion() {
        return this.moduleVersion;
    }

    public void setModuleVersion(String moduleVersion) {
        this.moduleVersion = moduleVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedStackTraceElement that = (ExtendedStackTraceElement)o;
        return this.lineNumber == that.lineNumber && this.exact == that.exact && (this.className != null ? this.className.equals(that.className) : that.className == null) && (this.methodName != null ? this.methodName.equals(that.methodName) : that.methodName == null) && (this.fileName != null ? this.fileName.equals(that.fileName) : that.fileName == null) && (this.codeLocation != null ? this.codeLocation.equals(that.codeLocation) : that.codeLocation == null) && (this.version != null ? this.version.equals(that.version) : that.version == null) && (this.classLoaderName != null ? this.classLoaderName.equals(that.classLoaderName) : that.classLoaderName == null) && (this.moduleName != null ? this.moduleName.equals(that.moduleName) : that.moduleName == null) && (this.moduleVersion != null ? this.moduleVersion.equals(that.moduleVersion) : that.moduleVersion == null);
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 31 * result + this.lineNumber;
        result = 31 * result + (this.codeLocation != null ? this.codeLocation.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.exact ? 1 : 0);
        result = 31 * result + (this.classLoaderName != null ? this.classLoaderName.hashCode() : 0);
        result = 31 * result + (this.moduleName != null ? this.moduleName.hashCode() : 0);
        result = 31 * result + (this.moduleVersion != null ? this.moduleVersion.hashCode() : 0);
        return result;
    }

    public StackTraceElement getStackTraceElement() {
        if (this.className == null || this.methodName == null) {
            return null;
        }
        return ExtendedStackTraceElement.createStackTraceElement(this.classLoaderName, this.moduleName, this.moduleVersion, this.className, this.methodName, this.fileName, this.lineNumber);
    }

    public ExtendedStackTraceElement clone() throws CloneNotSupportedException {
        return (ExtendedStackTraceElement)super.clone();
    }

    public String getExtendedString() {
        if (this.codeLocation != null || this.version != null) {
            return this.appendExtended(new StringBuilder()).toString();
        }
        return null;
    }

    private StringBuilder appendExtended(StringBuilder stringBuilder) {
        if (this.exact) {
            stringBuilder.append(EXTENDED_EXACT_PREFIX);
        } else {
            stringBuilder.append(EXTENDED_INEXACT_PREFIX);
        }
        if (this.codeLocation != null) {
            stringBuilder.append(this.codeLocation);
        } else {
            stringBuilder.append(NA_PLACEHOLDER);
        }
        stringBuilder.append(':');
        if (this.version != null) {
            stringBuilder.append(this.version);
        } else {
            stringBuilder.append(NA_PLACEHOLDER);
        }
        stringBuilder.append(EXTENDED_POSTFIX);
        return stringBuilder;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean extended) {
        return this.appendTo(new StringBuilder(), extended).toString();
    }

    public StringBuilder appendTo(StringBuilder stringBuilder, boolean extended) {
        Objects.requireNonNull(stringBuilder, "stringBuilder must not be null!");
        boolean separatorRequired = false;
        if (this.classLoaderName != null && !this.classLoaderName.isEmpty()) {
            stringBuilder.append(this.classLoaderName).append('/');
            separatorRequired = true;
        }
        if (this.moduleName != null && !this.moduleName.isEmpty()) {
            stringBuilder.append(this.moduleName);
            if (this.moduleVersion != null && !this.moduleVersion.isEmpty()) {
                stringBuilder.append('@').append(this.moduleVersion);
            }
            separatorRequired = true;
        }
        if (separatorRequired) {
            stringBuilder.append('/');
        }
        stringBuilder.append(this.className).append('.').append(this.methodName);
        if (this.isNativeMethod()) {
            stringBuilder.append('(').append(NATIVE_METHOD_STRING).append(')');
        } else if (this.fileName != null) {
            stringBuilder.append('(').append(this.fileName);
            if (this.lineNumber >= 0) {
                stringBuilder.append(':').append(this.lineNumber);
            }
            stringBuilder.append(')');
        } else {
            stringBuilder.append('(').append(UNKNOWN_SOURCE_STRING).append(')');
        }
        if (extended && (this.codeLocation != null || this.version != null)) {
            stringBuilder.append(' ');
            this.appendExtended(stringBuilder);
        }
        return stringBuilder;
    }

    public static ExtendedStackTraceElement parseStackTraceElement(String ste) {
        String remainder;
        int vEndIdx;
        if (ste == null) {
            return null;
        }
        int idx = ste.lastIndexOf(40);
        if (idx < 0) {
            return null;
        }
        int sourceEndIndex = ste.lastIndexOf(41);
        if (sourceEndIndex < 0) {
            return null;
        }
        String classAndMethod = ste.substring(0, idx);
        int classAndMethodDotIndex = classAndMethod.lastIndexOf(46);
        if (classAndMethodDotIndex < 0) {
            return null;
        }
        String classLoaderName = null;
        String moduleName = null;
        String moduleVersion = null;
        String clazz = classAndMethod.substring(0, classAndMethodDotIndex);
        int sourceStartIndex = idx + 1;
        idx = clazz.lastIndexOf(47);
        if (idx > -1) {
            String loaderModule = clazz.substring(0, idx);
            clazz = clazz.substring(idx + 1);
            idx = loaderModule.indexOf(47);
            if (idx > -1) {
                classLoaderName = loaderModule.substring(0, idx);
                moduleName = loaderModule.substring(idx + 1);
            } else {
                moduleName = loaderModule;
            }
            idx = moduleName.indexOf(64);
            if (idx > -1) {
                moduleVersion = moduleName.substring(idx + 1);
                moduleName = moduleName.substring(0, idx);
            }
        }
        if (classLoaderName != null && classLoaderName.isEmpty()) {
            classLoaderName = null;
        }
        if (moduleName != null && moduleName.isEmpty()) {
            moduleName = null;
        }
        if (moduleVersion != null && moduleVersion.isEmpty()) {
            moduleVersion = null;
        }
        String source = ste.substring(sourceStartIndex, sourceEndIndex);
        idx = source.lastIndexOf(58);
        String file = null;
        int lineNumber = -1;
        if (idx != -1) {
            file = source.substring(0, idx);
            String numberString = source.substring(idx + 1, source.length());
            try {
                lineNumber = Integer.parseInt(numberString);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        } else if (NATIVE_METHOD_STRING.equals(source)) {
            lineNumber = -2;
        } else if (!UNKNOWN_SOURCE_STRING.equals(source)) {
            file = source;
        }
        String method = classAndMethod.substring(classAndMethodDotIndex + 1, classAndMethod.length());
        ExtendedStackTraceElement result = null;
        if (sourceEndIndex + 2 < ste.length() && (vEndIdx = (remainder = ste.substring(sourceEndIndex + 2)).lastIndexOf(93)) >= 0) {
            int colonIdx;
            boolean exact = false;
            String versionStr = null;
            if (remainder.startsWith(EXTENDED_EXACT_PREFIX)) {
                exact = true;
                versionStr = remainder.substring(EXTENDED_EXACT_PREFIX.length(), vEndIdx);
            } else if (remainder.startsWith(EXTENDED_INEXACT_PREFIX)) {
                exact = false;
                versionStr = remainder.substring(EXTENDED_INEXACT_PREFIX.length(), vEndIdx);
            }
            if (versionStr != null && (colonIdx = versionStr.indexOf(58)) > -1) {
                String codeLocation = versionStr.substring(0, colonIdx);
                String version = versionStr.substring(colonIdx + 1);
                if (codeLocation.isEmpty() || NA_PLACEHOLDER.equals(codeLocation)) {
                    codeLocation = null;
                }
                if (version.isEmpty() || NA_PLACEHOLDER.equals(version)) {
                    version = null;
                }
                result = new ExtendedStackTraceElement(clazz, method, file, lineNumber, codeLocation, version, exact);
            }
        }
        if (result == null) {
            result = new ExtendedStackTraceElement(clazz, method, file, lineNumber);
        }
        result.setClassLoaderName(classLoaderName);
        result.setModuleName(moduleName);
        result.setModuleVersion(moduleVersion);
        return result;
    }

    private static String getClassLoaderNameFrom(StackTraceElement ste) {
        return ExtendedStackTraceElement.getValueFrom(GET_CLASS_LOADER_NAME, ste);
    }

    private static String getModuleNameFrom(StackTraceElement ste) {
        return ExtendedStackTraceElement.getValueFrom(GET_MODULE_NAME, ste);
    }

    private static String getModuleVersionFrom(StackTraceElement ste) {
        return ExtendedStackTraceElement.getValueFrom(GET_MODULE_VERSION, ste);
    }

    private static String getValueFrom(Method method, StackTraceElement ste) {
        if (method == null) {
            return null;
        }
        try {
            String result = (String)method.invoke((Object)ste, new Object[0]);
            if (result != null && !result.isEmpty()) {
                return result;
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static StackTraceElement createStackTraceElement(String classLoaderName, String moduleName, String moduleVersion, String declaringClass, String methodName, String fileName, int lineNumber) {
        if (FULL_CTOR != null) {
            try {
                return FULL_CTOR.newInstance(classLoaderName, moduleName, moduleVersion, declaringClass, methodName, fileName, lineNumber);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
    }

    static {
        Method method = null;
        try {
            method = StackTraceElement.class.getMethod("getClassLoaderNameFrom", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        GET_CLASS_LOADER_NAME = method;
        method = null;
        try {
            method = StackTraceElement.class.getMethod("getModuleName", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        GET_MODULE_NAME = method;
        method = null;
        try {
            method = StackTraceElement.class.getMethod("getModuleVersion", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        GET_MODULE_VERSION = method;
        Constructor ctor = null;
        try {
            ctor = StackTraceElement.class.getConstructor(String.class, String.class, String.class, String.class, String.class, String.class, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        FULL_CTOR = ctor;
    }
}

