/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.buffers;

import de.huxhorn.sulky.buffers.Buffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class BasicBufferIterator<E>
implements Iterator<E> {
    private final Buffer<E> buffer;
    private final long size;
    private long current;

    public BasicBufferIterator(Buffer<E> buffer) {
        this.buffer = Objects.requireNonNull(buffer, "buffer must not be null!");
        this.size = buffer.getSize();
        this.current = 0L;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.size;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Iterator doesn't have more entries");
        }
        E result = this.buffer.get(this.current);
        ++this.current;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Buffer does not support removal of arbitrary elements!");
    }
}

