/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.buffers;

import de.huxhorn.sulky.buffers.CircularBuffer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public final class OverwritingCircularBuffer<E>
implements CircularBuffer<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3423268103026176567L;
    private final int bufferSize;
    private transient int startIndex;
    private transient int endIndex;
    private transient long overflowCounter;
    private transient long size;
    private transient boolean full;
    private transient Object[] array;

    public OverwritingCircularBuffer(int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize (" + bufferSize + ") must be positive!");
        }
        this.bufferSize = bufferSize;
        this.array = new Object[bufferSize];
        this.reset();
    }

    @Override
    public void add(E element) {
        this.internalAdd(element);
    }

    private void internalAdd(Object element) {
        if (this.isFull()) {
            this.removeFirst();
            ++this.overflowCounter;
        }
        ++this.size;
        this.array[this.endIndex] = element;
        ++this.endIndex;
        if (this.endIndex == this.bufferSize) {
            this.endIndex = 0;
        }
        if (this.startIndex == this.endIndex) {
            this.full = true;
        }
    }

    @Override
    public void addAll(List<E> elements) {
        for (E element : elements) {
            this.add(element);
        }
    }

    @Override
    public void addAll(E[] elements) {
        for (E element : elements) {
            this.add(element);
        }
    }

    @Override
    public E get(long index) {
        if (index < 0L || index >= this.size) {
            throw new IndexOutOfBoundsException("Invalid index " + index + "! Must be 0.." + (this.size - 1L) + ".");
        }
        int realIndex = (int)(index - this.overflowCounter);
        if (realIndex < 0) {
            return null;
        }
        return this.getRelative(realIndex);
    }

    @Override
    public E getRelative(int index) {
        long availableElements = this.getAvailableElements();
        if (index < 0 || (long)index >= availableElements) {
            throw new IndexOutOfBoundsException("Invalid index " + index + "! Must be 0.." + (availableElements - 1L) + ".");
        }
        int realIndex = (this.startIndex + index) % this.bufferSize;
        Object result = this.array[realIndex];
        return (E)result;
    }

    @Override
    public E setRelative(int index, E element) {
        long availableElements = this.getAvailableElements();
        if (index < 0 || (long)index >= availableElements) {
            throw new IndexOutOfBoundsException("Invalid index " + index + "! Must be 0.." + (availableElements - 1L) + ".");
        }
        int realIndex = (this.startIndex + index) % this.bufferSize;
        Object result = this.array[realIndex];
        this.array[realIndex] = element;
        return (E)result;
    }

    @Override
    public E removeFirst() {
        if (this.isEmpty()) {
            return null;
        }
        Object result = this.array[this.startIndex];
        this.array[this.startIndex] = null;
        int newStart = this.startIndex + 1;
        if (newStart == this.bufferSize) {
            newStart = 0;
        }
        this.startIndex = newStart;
        this.full = false;
        return (E)result;
    }

    @Override
    public List<E> removeAll() {
        long availableElements = this.getAvailableElements();
        ArrayList<E> result = new ArrayList<E>((int)availableElements);
        int i = 0;
        while ((long)i < availableElements) {
            result.add(this.removeFirst());
            ++i;
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return !this.full && this.startIndex == this.endIndex;
    }

    @Override
    public boolean isFull() {
        return this.full && this.startIndex == this.endIndex;
    }

    @Override
    public void clear() {
        this.startIndex = 0;
        this.endIndex = 0;
        this.full = false;
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = null;
        }
    }

    @Override
    public void reset() {
        this.clear();
        this.overflowCounter = 0L;
        this.size = 0L;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public int getAvailableElements() {
        if (this.startIndex == this.endIndex) {
            if (this.full) {
                return this.bufferSize;
            }
            return 0;
        }
        if (this.startIndex < this.endIndex) {
            return this.endIndex - this.startIndex;
        }
        return this.bufferSize - this.startIndex + this.endIndex;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public long getOverflowCounter() {
        return this.overflowCounter;
    }

    @Override
    public Iterator<E> iterator() {
        return new BufferIterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof CircularBuffer)) {
            return false;
        }
        CircularBuffer that = (CircularBuffer)o;
        long availableElements = this.getAvailableElements();
        if (availableElements != (long)that.getAvailableElements()) {
            return false;
        }
        int i = 0;
        while ((long)i < availableElements) {
            E thisValue = this.getRelative(i);
            Object thatValue = that.getRelative(i);
            if (thisValue == null ? thatValue != null : !thisValue.equals(thatValue)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        for (E element : this) {
            if (element == null) continue;
            result = 17 * result + element.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('[');
        boolean first = true;
        for (E current : this) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(current);
        }
        result.append(']');
        return result.toString();
    }

    public OverwritingCircularBuffer<E> clone() throws CloneNotSupportedException {
        OverwritingCircularBuffer v = (OverwritingCircularBuffer)super.clone();
        v.array = (Object[])this.array.clone();
        return v;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        long availableElements = this.getAvailableElements();
        s.writeLong(availableElements);
        int i = 0;
        while ((long)i < availableElements) {
            s.writeObject(this.getRelative(i));
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.array = new Object[this.bufferSize];
        int elementCount = s.readInt();
        for (int i = 0; i < elementCount; ++i) {
            this.internalAdd(s.readObject());
        }
    }

    private class BufferIterator
    implements Iterator<E> {
        int current = 0;

        BufferIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < OverwritingCircularBuffer.this.getAvailableElements();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Iterator doesn't have more entries");
            }
            Object result = OverwritingCircularBuffer.this.getRelative(this.current);
            ++this.current;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Buffer does not support removal of arbitrary elements!");
        }
    }
}

