/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.buffers;

import de.huxhorn.sulky.buffers.BasicBufferIterator;
import de.huxhorn.sulky.buffers.FileBuffer;
import java.io.File;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializingFileBuffer<E>
implements FileBuffer<E> {
    private final Logger logger = LoggerFactory.getLogger(SerializingFileBuffer.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private File dataFile;
    private File indexFile;
    private static final String INDEX_EXTENSION = ".index";

    public SerializingFileBuffer(File dataFile) {
        this(dataFile, null);
    }

    public SerializingFileBuffer(File dataFile, File indexFile) {
        this.setDataFile(dataFile);
        if (indexFile == null) {
            File parent = dataFile.getParentFile();
            String indexName = dataFile.getName();
            int dotIndex = indexName.lastIndexOf(46);
            if (dotIndex > 0) {
                indexName = indexName.substring(0, dotIndex);
            }
            indexName = indexName + INDEX_EXTENSION;
            indexFile = new File(parent, indexName);
        }
        this.setIndexFile(indexFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public long getSize() {
        Throwable throwable;
        long l;
        Throwable throwable2;
        RandomAccessFile raf;
        Lock lock;
        block18: {
            block19: {
                if (!this.indexFile.canRead()) {
                    return 0L;
                }
                lock = this.readWriteLock.readLock();
                lock.lock();
                raf = new RandomAccessFile(this.indexFile, "r");
                throwable2 = null;
                l = this.internalGetSize(raf);
                if (raf == null) break block18;
                if (throwable2 == null) break block19;
                try {
                    raf.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                break block18;
            }
            raf.close();
        }
        lock.unlock();
        return l;
        catch (Throwable throwable4) {
            try {
                try {
                    try {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (raf != null) {
                            if (throwable2 != null) {
                                try {
                                    raf.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                            } else {
                                raf.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (Throwable e) {
                    throwable = e;
                    lock.unlock();
                }
            }
            catch (Throwable throwable7) {
                lock.unlock();
                throw throwable7;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Couldn't retrieve size!", throwable);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E get(long index) {
        if (!this.dataFile.canRead()) return null;
        if (!this.indexFile.canRead()) {
            return null;
        }
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        Throwable throwable = null;
        try (RandomAccessFile randomSerializeIndexFile = new RandomAccessFile(this.indexFile, "r");
             RandomAccessFile randomSerializeFile = new RandomAccessFile(this.dataFile, "r");){
            long elementsCount = this.internalGetSize(randomSerializeIndexFile);
            if (index >= 0L && index < elementsCount) {
                long offset = this.internalOffsetOfElement(randomSerializeIndexFile, index);
                E e = this.internalReadElement(randomSerializeFile, offset);
                return e;
            }
        }
        catch (Throwable e) {
            throwable = e;
        }
        finally {
            lock.unlock();
        }
        if (throwable instanceof ClassNotFoundException || throwable instanceof InvalidClassException) {
            if (!this.logger.isWarnEnabled()) return null;
            this.logger.warn("Couldn't deserialize object at index {}!\n{}", (Object)index, (Object)throwable);
            return null;
        }
        if (throwable instanceof ClassCastException) {
            if (!this.logger.isWarnEnabled()) return null;
            this.logger.warn("Couldn't cast deserialized object at index {}!\n{}", (Object)index, (Object)throwable);
            return null;
        }
        if (!this.logger.isWarnEnabled()) return null;
        this.logger.warn("Couldn't retrieve element at index {}!", (Object)index, (Object)throwable);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(E element) {
        IOException throwable = null;
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try (RandomAccessFile randomSerializeIndexFile = new RandomAccessFile(this.indexFile, "rw");
             RandomAccessFile randomSerializeFile = new RandomAccessFile(this.dataFile, "rw");){
            long elementsCount = this.internalGetSize(randomSerializeIndexFile);
            long offset = 0L;
            if (elementsCount > 0L) {
                long prevElement = elementsCount - 1L;
                offset = this.internalOffsetOfElement(randomSerializeIndexFile, prevElement);
                offset = offset + this.internalReadElementSize(randomSerializeFile, offset) + 4L;
            }
            this.internalWriteElement(randomSerializeFile, offset, element);
            this.internalWriteOffset(randomSerializeIndexFile, elementsCount, offset);
        }
        catch (IOException e) {
            throwable = e;
        }
        finally {
            lock.unlock();
        }
        if (throwable != null && this.logger.isWarnEnabled()) {
            this.logger.warn("Couldn't write element!", (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAll(List<E> elements) {
        int newElementCount;
        if (elements != null && (newElementCount = elements.size()) > 0) {
            Throwable throwable = null;
            Lock lock = this.readWriteLock.writeLock();
            lock.lock();
            try (RandomAccessFile randomSerializeIndexFile = new RandomAccessFile(this.indexFile, "rw");
                 RandomAccessFile randomSerializeFile = new RandomAccessFile(this.dataFile, "rw");){
                long elementsCount = this.internalGetSize(randomSerializeIndexFile);
                long offset = 0L;
                if (elementsCount > 0L) {
                    long prevElement = elementsCount - 1L;
                    offset = this.internalOffsetOfElement(randomSerializeIndexFile, prevElement);
                    offset = offset + this.internalReadElementSize(randomSerializeFile, offset) + 4L;
                }
                long[] offsets = new long[elements.size()];
                int index = 0;
                for (E element : elements) {
                    offsets[index] = offset;
                    offset = offset + (long)this.internalWriteElement(randomSerializeFile, offset, element) + 4L;
                    ++index;
                }
                index = 0;
                for (Object curOffset : (Object)offsets) {
                    this.internalWriteOffset(randomSerializeIndexFile, elementsCount + (long)index, (long)curOffset);
                    ++index;
                }
            }
            catch (Throwable e) {
                throwable = e;
            }
            finally {
                lock.unlock();
            }
            if (throwable != null && this.logger.isWarnEnabled()) {
                this.logger.warn("Couldn't write element!", throwable);
            }
        }
    }

    @Override
    public void addAll(E[] elements) {
        this.addAll(Arrays.asList(elements));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        boolean dataDeleted;
        boolean indexDeleted;
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            indexDeleted = this.indexFile.delete();
            dataDeleted = this.dataFile.delete();
        }
        finally {
            lock.unlock();
        }
        if (!indexDeleted && this.logger.isDebugEnabled()) {
            this.logger.debug("Couldn't delete index file {}.", (Object)this.indexFile.getAbsolutePath());
        }
        if (!dataDeleted && this.logger.isDebugEnabled()) {
            this.logger.debug("Couldn't delete data file {}.", (Object)this.dataFile.getAbsolutePath());
        }
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new BasicBufferIterator(this);
    }

    @Override
    public File getDataFile() {
        return this.dataFile;
    }

    private long internalOffsetOfElement(RandomAccessFile randomSerializeIndexFile, long index) throws IOException {
        long offsetOffset = 8L * index;
        if (randomSerializeIndexFile.length() < offsetOffset + 8L) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + "!");
        }
        randomSerializeIndexFile.seek(offsetOffset);
        return randomSerializeIndexFile.readLong();
    }

    private long internalGetSize(RandomAccessFile randomSerializeIndexFile) throws IOException {
        return randomSerializeIndexFile.length() / 8L;
    }

    /*
     * Exception decompiling
     */
    private E internalReadElement(RandomAccessFile randomSerializeFile, long offset) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void internalWriteOffset(RandomAccessFile randomSerializeIndexFile, long index, long offset) throws IOException {
        long offsetOffset = 8L * index;
        if (randomSerializeIndexFile.length() < offsetOffset) {
            throw new IOException("Invalid offsetOffset " + offsetOffset + "!");
        }
        randomSerializeIndexFile.seek(offsetOffset);
        randomSerializeIndexFile.writeLong(offset);
    }

    /*
     * Exception decompiling
     */
    private int internalWriteElement(RandomAccessFile randomSerializeFile, long offset, E element) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long internalReadElementSize(RandomAccessFile randomSerializeFile, long offset) throws IOException {
        randomSerializeFile.seek(offset);
        return randomSerializeFile.readInt();
    }

    private void setDataFile(File dataFile) {
        this.prepareFile(dataFile);
        this.dataFile = dataFile;
    }

    private void setIndexFile(File indexFile) {
        this.prepareFile(indexFile);
        this.indexFile = indexFile;
    }

    private void prepareFile(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            if (parent.mkdirs() && this.logger.isDebugEnabled()) {
                this.logger.debug("Created directory {}.", (Object)parent.getAbsolutePath());
            }
            if (!parent.isDirectory()) {
                throw new IllegalArgumentException(parent.getAbsolutePath() + " is not a directory!");
            }
            if (file.isFile() && !file.canWrite()) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " is not writable!");
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(200);
        result.append("SerializingFileBuffer[dataFile=");
        if (this.dataFile == null) {
            result.append("null");
        } else {
            result.append('\"').append(this.dataFile.getAbsolutePath()).append('\"');
        }
        result.append(", indexFile=");
        if (this.indexFile == null) {
            result.append("null");
        } else {
            result.append('\"').append(this.indexFile.getAbsolutePath()).append('\"');
        }
        result.append(']');
        return result.toString();
    }
}

