/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.buffers;

import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.Dispose;
import de.huxhorn.sulky.buffers.DisposeOperation;
import de.huxhorn.sulky.buffers.Flush;
import de.huxhorn.sulky.buffers.FlushOperation;
import de.huxhorn.sulky.buffers.Reset;
import de.huxhorn.sulky.buffers.ResetOperation;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftReferenceCachingBuffer<E>
implements Buffer<E>,
ResetOperation,
DisposeOperation,
FlushOperation {
    private final Logger logger = LoggerFactory.getLogger(SoftReferenceCachingBuffer.class);
    private static final ReferenceQueue REFERENCE_QUEUE = new ReferenceQueue();
    private final Buffer<E> buffer;
    private final Map<Long, MySoftReference<E>> cache;
    private boolean disposed = false;

    public SoftReferenceCachingBuffer(Buffer<E> buffer) {
        this.buffer = buffer;
        this.cache = new ConcurrentHashMap<Long, MySoftReference<E>>();
    }

    Buffer<E> getWrappedBuffer() {
        return this.buffer;
    }

    @Override
    public E get(long index) {
        Object result;
        if (this.disposed) {
            return null;
        }
        SoftReference softy = this.cache.get(index);
        if (softy != null) {
            result = softy.get();
            if (result == null) {
                this.cache.remove(index);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Retrieved {} from cache.", (Object)index);
                }
                return (E)result;
            }
        }
        if ((result = this.buffer.get(index)) != null) {
            this.cache.put(index, new MySoftReference<E>(this.cache, index, result));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Added {} to cache.", (Object)index);
            }
        }
        return (E)result;
    }

    @Override
    public long getSize() {
        return this.buffer.getSize();
    }

    @Override
    public Iterator<E> iterator() {
        return this.buffer.iterator();
    }

    @Override
    public void reset() {
        Reset.reset(this.buffer);
        this.cache.clear();
    }

    @Override
    public void dispose() {
        this.disposed = true;
        this.cache.clear();
        Dispose.dispose(this.buffer);
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void flush() {
        Flush.flush(this.buffer);
        this.cache.clear();
    }

    static {
        Thread cleanupThread = new Thread((Runnable)new ReferenceQueueRunnable(), "ReferenceQueue-Cleanup");
        cleanupThread.setDaemon(true);
        cleanupThread.start();
        Logger logger = LoggerFactory.getLogger(SoftReferenceCachingBuffer.class);
        if (logger.isInfoEnabled()) {
            logger.info("Started thread {}.", (Object)cleanupThread);
        }
    }

    private static class ReferenceQueueRunnable
    implements Runnable {
        private ReferenceQueueRunnable() {
        }

        @Override
        public void run() {
            Logger logger = LoggerFactory.getLogger(SoftReferenceCachingBuffer.class);
            try {
                while (true) {
                    Reference ref;
                    if ((ref = REFERENCE_QUEUE.remove()) instanceof MySoftReference) {
                        MySoftReference reference = (MySoftReference)ref;
                        reference.removeFromCache();
                        continue;
                    }
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("Unexpected reference!! {}", ref);
                }
            }
            catch (InterruptedException e) {
                block4: {
                    if (!logger.isInfoEnabled()) break block4;
                    logger.info("Interrupted ReferenceQueueRunnable...");
                }
                return;
            }
        }
    }

    private static class MySoftReference<E>
    extends SoftReference<E> {
        private final long index;
        private final Map<Long, MySoftReference<E>> cache;

        MySoftReference(Map<Long, MySoftReference<E>> cache, long index, E referent) {
            super(referent, REFERENCE_QUEUE);
            this.index = index;
            this.cache = cache;
        }

        public long getIndex() {
            return this.index;
        }

        void removeFromCache() {
            this.cache.remove(this.index);
            Logger logger = LoggerFactory.getLogger(SoftReferenceCachingBuffer.class);
            if (logger.isDebugEnabled()) {
                logger.debug("Removed {} from cache.", (Object)this.index);
            }
        }
    }
}

