/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.filebuffer;

import de.huxhorn.sulky.buffers.BasicBufferIterator;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.Dispose;
import de.huxhorn.sulky.buffers.DisposeOperation;
import de.huxhorn.sulky.buffers.ElementProcessor;
import de.huxhorn.sulky.buffers.FileBuffer;
import de.huxhorn.sulky.buffers.Reset;
import de.huxhorn.sulky.buffers.SetOperation;
import de.huxhorn.sulky.codec.Codec;
import de.huxhorn.sulky.codec.filebuffer.DataStrategy;
import de.huxhorn.sulky.codec.filebuffer.DefaultDataStrategy;
import de.huxhorn.sulky.codec.filebuffer.DefaultFileHeaderStrategy;
import de.huxhorn.sulky.codec.filebuffer.DefaultIndexStrategy;
import de.huxhorn.sulky.codec.filebuffer.FileHeader;
import de.huxhorn.sulky.codec.filebuffer.FileHeaderStrategy;
import de.huxhorn.sulky.codec.filebuffer.IndexStrategy;
import de.huxhorn.sulky.codec.filebuffer.MetaData;
import de.huxhorn.sulky.codec.filebuffer.SparseDataStrategy;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecFileBuffer<E>
implements FileBuffer<E>,
SetOperation<E>,
DisposeOperation {
    private final Logger logger = LoggerFactory.getLogger(CodecFileBuffer.class);
    private final ReadWriteLock readWriteLock;
    private File dataFile;
    private File indexFile;
    private static final String INDEX_EXTENSION = ".index";
    private Map<String, String> preferredMetaData;
    private Codec<E> codec;
    private List<ElementProcessor<E>> elementProcessors;
    private FileHeaderStrategy fileHeaderStrategy;
    private int magicValue;
    private FileHeader fileHeader;
    private boolean preferredSparse;
    private DataStrategy<E> dataStrategy;
    private IndexStrategy indexStrategy = new DefaultIndexStrategy();

    public CodecFileBuffer(int magicValue, boolean sparse, Map<String, String> preferredMetaData, Codec<E> codec, File dataFile, File indexFile) {
        this(magicValue, sparse, preferredMetaData, codec, dataFile, indexFile, new DefaultFileHeaderStrategy());
    }

    public CodecFileBuffer(int magicValue, boolean preferredSparse, Map<String, String> preferredMetaData, Codec<E> codec, File dataFile, File indexFile, FileHeaderStrategy fileHeaderStrategy) {
        this.magicValue = magicValue;
        this.fileHeaderStrategy = fileHeaderStrategy;
        this.readWriteLock = new ReentrantReadWriteLock(true);
        this.preferredSparse = preferredSparse;
        if (preferredMetaData != null) {
            preferredMetaData = new HashMap<String, String>(preferredMetaData);
        }
        if (preferredMetaData != null) {
            this.preferredMetaData = new HashMap<String, String>(preferredMetaData);
        }
        this.codec = codec;
        this.setDataFile(dataFile);
        if (indexFile == null) {
            File parent = dataFile.getParentFile();
            String indexName = dataFile.getName();
            int dotIndex = indexName.lastIndexOf(46);
            if (dotIndex > 0) {
                indexName = indexName.substring(0, dotIndex);
            }
            indexName = indexName + INDEX_EXTENSION;
            indexFile = new File(parent, indexName);
        }
        this.setIndexFile(indexFile);
        if (!this.initFilesIfNecessary()) {
            this.validateHeader();
        }
    }

    private void validateHeader() {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            this.fileHeader = null;
            FileHeader header = this.fileHeaderStrategy.readFileHeader(this.dataFile);
            if (header == null) {
                throw new IllegalArgumentException("Could not read file header from file '" + this.dataFile.getAbsolutePath() + "'. File isn't compatible.");
            }
            if (header.getMagicValue() != this.magicValue) {
                throw new IllegalArgumentException("Wrong magic value. Expected 0x" + Integer.toHexString(this.magicValue) + " but was " + Integer.toHexString(header.getMagicValue()) + "!");
            }
            if (this.dataFile.length() > header.getDataOffset() && !this.indexFile.exists()) {
                throw new IllegalArgumentException("dataFile contains data but indexFile " + this.indexFile.getAbsolutePath() + " is not valid!");
            }
            this.setFileHeader(header);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not read magic value from file '" + this.dataFile.getAbsolutePath() + "'!", ex);
        }
        finally {
            lock.unlock();
        }
    }

    public Codec<E> getCodec() {
        return this.codec;
    }

    public void setCodec(Codec<E> codec) {
        this.codec = codec;
    }

    public List<ElementProcessor<E>> getElementProcessors() {
        if (this.elementProcessors == null) {
            return null;
        }
        return Collections.unmodifiableList(this.elementProcessors);
    }

    public void setElementProcessors(List<ElementProcessor<E>> elementProcessors) {
        if (elementProcessors != null) {
            elementProcessors = elementProcessors.isEmpty() ? null : new ArrayList<ElementProcessor<ElementProcessor<ElementProcessor<ElementProcessor<E>>>>>(elementProcessors);
        }
        this.elementProcessors = elementProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initFilesIfNecessary() {
        if (!this.dataFile.exists() || this.dataFile.length() < (long)this.fileHeaderStrategy.getMinimalSize()) {
            IOException t = null;
            boolean dataDeleted = false;
            boolean indexDeleted = false;
            Lock lock = this.readWriteLock.writeLock();
            lock.lock();
            try {
                dataDeleted = this.dataFile.delete();
                this.setFileHeader(this.fileHeaderStrategy.writeFileHeader(this.dataFile, this.magicValue, this.preferredMetaData, this.preferredSparse));
                indexDeleted = this.indexFile.delete();
            }
            catch (IOException e) {
                t = e;
            }
            finally {
                lock.unlock();
            }
            if (!indexDeleted && this.logger.isDebugEnabled()) {
                this.logger.debug("Couldn't delete index file {}.", (Object)this.indexFile.getAbsolutePath());
            }
            if (!dataDeleted && this.logger.isDebugEnabled()) {
                this.logger.debug("Couldn't delete data file {}.", (Object)this.dataFile.getAbsolutePath());
            }
            if (t != null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while initializing files!", (Throwable)t);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public Map<String, String> getPreferredMetaData() {
        if (this.preferredMetaData == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.preferredMetaData);
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long getSize() {
        Throwable throwable;
        long l;
        Throwable throwable2;
        RandomAccessFile raf;
        Lock lock;
        block18: {
            block19: {
                if (!this.indexFile.canRead()) {
                    return 0L;
                }
                lock = this.readWriteLock.readLock();
                lock.lock();
                raf = new RandomAccessFile(this.indexFile, "r");
                throwable2 = null;
                l = this.indexStrategy.getSize(raf);
                if (raf == null) break block18;
                if (throwable2 == null) break block19;
                try {
                    raf.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                break block18;
            }
            raf.close();
        }
        lock.unlock();
        return l;
        catch (Throwable throwable4) {
            try {
                try {
                    try {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (raf != null) {
                            if (throwable2 != null) {
                                try {
                                    raf.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                            } else {
                                raf.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (Throwable e) {
                    throwable = e;
                    lock.unlock();
                }
            }
            catch (Throwable throwable7) {
                lock.unlock();
                throw throwable7;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Couldn't retrieve size!", throwable);
        }
        return 0L;
    }

    /*
     * Exception decompiling
     */
    public E get(long index) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E element) {
        this.initFilesIfNecessary();
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        IOException throwable = null;
        try (RandomAccessFile randomIndexFile = new RandomAccessFile(this.indexFile, "rw");
             RandomAccessFile randomDataFile = new RandomAccessFile(this.dataFile, "rw");){
            this.dataStrategy.add(element, randomIndexFile, randomDataFile, this.codec, this.indexStrategy);
            List<ElementProcessor<E>> localProcessors = this.elementProcessors;
            if (localProcessors != null) {
                for (ElementProcessor<E> current : this.elementProcessors) {
                    current.processElement(element);
                }
            }
        }
        catch (IOException e) {
            throwable = e;
        }
        finally {
            lock.unlock();
        }
        if (throwable != null && this.logger.isWarnEnabled()) {
            this.logger.warn("Couldn't write element!", (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void addAll(List<E> elements) {
        block35: {
            Throwable throwable;
            Throwable throwable2;
            RandomAccessFile randomDataFile;
            Throwable throwable3;
            RandomAccessFile randomIndexFile;
            Lock lock;
            block33: {
                block34: {
                    block31: {
                        block32: {
                            if (elements == null) break block35;
                            this.initFilesIfNecessary();
                            int newElementCount = elements.size();
                            if (newElementCount <= 0) break block35;
                            lock = this.readWriteLock.writeLock();
                            lock.lock();
                            randomIndexFile = new RandomAccessFile(this.indexFile, "rw");
                            throwable3 = null;
                            randomDataFile = new RandomAccessFile(this.dataFile, "rw");
                            throwable2 = null;
                            this.dataStrategy.addAll(elements, randomIndexFile, randomDataFile, this.codec, this.indexStrategy);
                            if (this.elementProcessors != null) {
                                for (ElementProcessor<E> current : this.elementProcessors) {
                                    current.processElements(elements);
                                }
                            }
                            if (randomDataFile == null) break block31;
                            if (throwable2 == null) break block32;
                            try {
                                randomDataFile.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            break block31;
                        }
                        randomDataFile.close();
                    }
                    if (randomIndexFile == null) break block33;
                    if (throwable3 == null) break block34;
                    try {
                        randomIndexFile.close();
                    }
                    catch (Throwable throwable5) {
                        throwable3.addSuppressed(throwable5);
                    }
                    break block33;
                }
                randomIndexFile.close();
            }
            lock.unlock();
            return;
            {
                catch (Throwable throwable6) {
                    try {
                        try {
                            try {
                                try {
                                    try {
                                        throwable2 = throwable6;
                                        throw throwable6;
                                    }
                                    catch (Throwable throwable7) {
                                        if (randomDataFile != null) {
                                            if (throwable2 != null) {
                                                try {
                                                    randomDataFile.close();
                                                }
                                                catch (Throwable throwable8) {
                                                    throwable2.addSuppressed(throwable8);
                                                }
                                            } else {
                                                randomDataFile.close();
                                            }
                                        }
                                        throw throwable7;
                                    }
                                }
                                catch (Throwable throwable9) {
                                    throwable3 = throwable9;
                                    throw throwable9;
                                }
                            }
                            catch (Throwable throwable10) {
                                if (randomIndexFile != null) {
                                    if (throwable3 != null) {
                                        try {
                                            randomIndexFile.close();
                                        }
                                        catch (Throwable throwable11) {
                                            throwable3.addSuppressed(throwable11);
                                        }
                                    } else {
                                        randomIndexFile.close();
                                    }
                                }
                                throw throwable10;
                            }
                        }
                        catch (Throwable e) {
                            throwable = e;
                            lock.unlock();
                        }
                    }
                    catch (Throwable throwable12) {
                        lock.unlock();
                        throw throwable12;
                    }
                }
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Couldn't write element!", throwable);
            }
        }
    }

    public void addAll(E[] elements) {
        this.addAll(Arrays.asList(elements));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        IOException t = null;
        boolean indexDeleted = false;
        boolean dataDeleted = false;
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            indexDeleted = this.indexFile.delete();
            dataDeleted = this.dataFile.delete();
            this.fileHeaderStrategy.writeFileHeader(this.dataFile, this.magicValue, this.preferredMetaData, this.preferredSparse);
            if (this.elementProcessors != null) {
                for (ElementProcessor<E> current : this.elementProcessors) {
                    Reset.reset(current);
                }
            }
        }
        catch (IOException e) {
            t = e;
        }
        finally {
            lock.unlock();
        }
        if (!indexDeleted && this.logger.isDebugEnabled()) {
            this.logger.debug("Couldn't delete index file {}.", (Object)this.indexFile.getAbsolutePath());
        }
        if (!dataDeleted && this.logger.isDebugEnabled()) {
            this.logger.debug("Couldn't delete data file {}.", (Object)this.dataFile.getAbsolutePath());
        }
        if (t != null && this.logger.isWarnEnabled()) {
            this.logger.warn("Exception while resetting file!", (Throwable)t);
        }
    }

    public boolean isFull() {
        return false;
    }

    public Iterator<E> iterator() {
        return new BasicBufferIterator((Buffer)this);
    }

    private void setDataFile(File dataFile) {
        this.prepareFile(dataFile);
        this.dataFile = dataFile;
    }

    private void setIndexFile(File indexFile) {
        this.prepareFile(indexFile);
        this.indexFile = indexFile;
    }

    private void prepareFile(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            if (parent.mkdirs() && this.logger.isDebugEnabled()) {
                this.logger.debug("Created directory {}.", (Object)parent.getAbsolutePath());
            }
            if (!parent.isDirectory()) {
                throw new IllegalArgumentException(parent.getAbsolutePath() + " is not a directory!");
            }
            if (file.isFile() && !file.canWrite()) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " is not writable!");
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(300);
        result.append("CodecFileBuffer[fileHeader=").append(this.fileHeader).append(", preferredMetaData=").append(this.preferredMetaData).append(", dataFile=");
        if (this.dataFile == null) {
            result.append("null");
        } else {
            result.append('\"').append(this.dataFile.getAbsolutePath()).append('\"');
        }
        result.append(", indexFile=");
        if (this.indexFile == null) {
            result.append("null");
        } else {
            result.append('\"').append(this.indexFile.getAbsolutePath()).append('\"');
        }
        result.append(", codec=").append(this.codec).append(']');
        return result.toString();
    }

    public void dispose() {
        if (this.elementProcessors != null) {
            for (ElementProcessor<E> current : this.elementProcessors) {
                Dispose.dispose(current);
            }
        }
    }

    public boolean isDisposed() {
        return false;
    }

    private void setFileHeader(FileHeader fileHeader) {
        MetaData metaData = fileHeader.getMetaData();
        this.dataStrategy = metaData.isSparse() ? new SparseDataStrategy() : new DefaultDataStrategy();
        this.fileHeader = fileHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(long index, E element) {
        this.initFilesIfNecessary();
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        IOException throwable = null;
        boolean result = false;
        try (RandomAccessFile randomIndexFile = new RandomAccessFile(this.indexFile, "rw");
             RandomAccessFile randomDataFile = new RandomAccessFile(this.dataFile, "rw");){
            result = this.dataStrategy.set(index, element, randomIndexFile, randomDataFile, this.codec, this.indexStrategy);
            List<ElementProcessor<E>> localProcessors = this.elementProcessors;
            if (localProcessors != null) {
                for (ElementProcessor<E> current : this.elementProcessors) {
                    current.processElement(element);
                }
            }
        }
        catch (IOException e) {
            throwable = e;
        }
        finally {
            lock.unlock();
        }
        if (throwable != null && this.logger.isWarnEnabled()) {
            this.logger.warn("Couldn't write element!", (Throwable)throwable);
        }
        return result;
    }

    public boolean isSetSupported() {
        return this.dataStrategy != null && this.dataStrategy.isSetSupported();
    }
}

