/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.filebuffer;

import de.huxhorn.sulky.codec.Codec;
import de.huxhorn.sulky.codec.filebuffer.DataStrategy;
import de.huxhorn.sulky.codec.filebuffer.IndexStrategy;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;

public class DefaultDataStrategy<E>
implements DataStrategy<E> {
    public static final long DATA_LENGTH_SIZE = 4L;

    @Override
    public void add(E element, RandomAccessFile indexFile, RandomAccessFile dataFile, Codec<E> codec, IndexStrategy indexStrategy) throws IOException {
        long elementsCount = indexStrategy.getSize(indexFile);
        long offset = dataFile.length();
        this.internalWriteElement(dataFile, offset, element, codec);
        indexStrategy.setOffset(indexFile, elementsCount, offset);
    }

    @Override
    public void addAll(List<E> elements, RandomAccessFile indexFile, RandomAccessFile dataFile, Codec<E> codec, IndexStrategy indexStrategy) throws IOException {
        int newElementCount;
        if (elements != null && (newElementCount = elements.size()) > 0) {
            long elementsCount = indexStrategy.getSize(indexFile);
            long offset = dataFile.length();
            long[] offsets = new long[newElementCount];
            int index = 0;
            for (E element : elements) {
                offsets[index] = offset;
                offset = offset + (long)this.internalWriteElement(dataFile, offset, element, codec) + 4L;
                ++index;
            }
            index = 0;
            for (Object curOffset : (Object)offsets) {
                indexStrategy.setOffset(indexFile, elementsCount + (long)index, (long)curOffset);
                ++index;
            }
        }
    }

    @Override
    public boolean set(long index, E element, RandomAccessFile indexFile, RandomAccessFile dataFile, Codec<E> codec, IndexStrategy indexStrategy) {
        throw new UnsupportedOperationException("DefaultDataStrategy does not support set!");
    }

    @Override
    public boolean isSetSupported() {
        return false;
    }

    @Override
    public E get(long index, RandomAccessFile indexFile, RandomAccessFile dataFile, Codec<E> codec, IndexStrategy indexStrategy) throws IOException, ClassNotFoundException {
        long elementsCount = indexStrategy.getSize(indexFile);
        if (index >= 0L && index < elementsCount) {
            long offset = indexStrategy.getOffset(indexFile, index);
            if (offset < 0L) {
                return null;
            }
            return this.internalReadElement(dataFile, offset, codec);
        }
        return null;
    }

    private int internalWriteElement(RandomAccessFile dataFile, long offset, E element, Codec<E> codec) throws IOException {
        if (codec == null) {
            throw new IllegalStateException("Codec has not been initialized!");
        }
        byte[] buffer = codec.encode(element);
        int bufferSize = buffer.length;
        dataFile.seek(offset);
        dataFile.writeInt(bufferSize);
        dataFile.write(buffer);
        return bufferSize;
    }

    private E internalReadElement(RandomAccessFile dataFile, long offset, Codec<E> codec) throws IOException {
        if (codec == null) {
            throw new IllegalStateException("Codec has not been initialized!");
        }
        if (dataFile.length() < offset + 4L) {
            throw new IndexOutOfBoundsException("Invalid offset: " + offset + "! Couldn't read length of data!");
        }
        dataFile.seek(offset);
        int bufferSize = dataFile.readInt();
        if (dataFile.length() < offset + 4L + (long)bufferSize) {
            throw new IndexOutOfBoundsException("Invalid length (" + bufferSize + ") at offset: " + offset + "!");
        }
        byte[] buffer = new byte[bufferSize];
        dataFile.readFully(buffer);
        return (E)codec.decode(buffer);
    }
}

