/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec;

import de.huxhorn.sulky.codec.Decoder;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public class XmlDecoder<E>
implements Decoder<E> {
    private boolean compressing;

    public XmlDecoder() {
        this(false);
    }

    public XmlDecoder(boolean compressing) {
        this.setCompressing(compressing);
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E decode(byte[] bytes) {
        try (XMLDecoder decoder = this.createXMLDecoder(bytes);){
            Object result;
            Object e;
            Object object = e = (result = decoder.readObject());
            return (E)object;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private XMLDecoder createXMLDecoder(byte[] bytes) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        if (this.compressing) {
            GZIPInputStream gis = new GZIPInputStream(bis);
            return new XMLDecoder(gis);
        }
        return new XMLDecoder(bis);
    }

    public String toString() {
        return "XmlDecoder[compressing=" + this.compressing + "]";
    }
}

