/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.streaming;

import de.huxhorn.sulky.codec.Decoder;
import de.huxhorn.sulky.codec.streaming.StreamingDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderBridge<E>
implements Decoder<E> {
    private final Logger logger = LoggerFactory.getLogger(DecoderBridge.class);
    private final StreamingDecoder<E> wrapped;

    public DecoderBridge(StreamingDecoder<E> wrapped) {
        this.wrapped = Objects.requireNonNull(wrapped, "wrapped must not be null!");
    }

    @Override
    public E decode(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            return this.wrapped.decode(bis);
        }
        catch (IOException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Couldn't decode!", (Throwable)e);
            }
            return null;
        }
    }
}

