/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec;

import de.huxhorn.sulky.codec.Decoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;

public class SerializableDecoder<E extends Serializable>
implements Decoder<E> {
    private boolean compressing;

    public SerializableDecoder() {
        this(false);
    }

    public SerializableDecoder(boolean compressing) {
        this.setCompressing(compressing);
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E decode(byte[] bytes) {
        try (ObjectInputStream ois = this.createObjectInputStream(bytes);){
            Serializable e;
            Object result = ois.readObject();
            Serializable serializable = e = (Serializable)result;
            return (E)serializable;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private ObjectInputStream createObjectInputStream(byte[] bytes) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        if (this.compressing) {
            GZIPInputStream gis = new GZIPInputStream(bis);
            return new ObjectInputStream(gis);
        }
        return new ObjectInputStream(bis);
    }

    public String toString() {
        return "SerializableDecoder[compressing=" + this.compressing + "]";
    }
}

