/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec;

import de.huxhorn.sulky.codec.Encoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;

public class XmlEncoder<E>
implements Encoder<E> {
    private boolean compressing;

    public XmlEncoder() {
        this(false);
    }

    public XmlEncoder(boolean compressing) {
        this.compressing = compressing;
    }

    public XmlEncoder(boolean compressing, Class ... ignored) {
        this(compressing);
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] encode(E object) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (XMLEncoder encoder = this.createXmlEncoder(bos);){
            encoder.writeObject(object);
            encoder.close();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private XMLEncoder createXmlEncoder(ByteArrayOutputStream bos) throws IOException {
        if (this.compressing) {
            GZIPOutputStream gos = new GZIPOutputStream(bos);
            return new XMLEncoder(gos);
        }
        return new XMLEncoder(bos);
    }

    public String toString() {
        return "XmlEncoder[compressing=" + this.compressing + "]";
    }
}

