/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.ulid;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;

public class ULID {
    private static final char[] ENCODING_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    private static final byte[] DECODING_CHARS = new byte[128];
    private static final int MASK = 31;
    private static final int MASK_BITS = 5;
    private static final long TIMESTAMP_MASK = 0xFFFFFFFFFFFFL;
    private final Random random;

    static void internalAppendCrockford(StringBuilder builder, long value, int count) {
        for (int i = count - 1; i >= 0; --i) {
            int index = (int)(value >>> i * 5 & 0x1FL);
            builder.append(ENCODING_CHARS[index]);
        }
    }

    static long internalParseCrockford(String input) {
        Objects.requireNonNull(input, "input must not be null!");
        long result = 0L;
        int length = input.length();
        if (length > 12) {
            throw new IllegalArgumentException("input length must not exceed 12 but was " + length + "!");
        }
        for (int i = 0; i < length; ++i) {
            char current = input.charAt(i);
            int value = -1;
            if (current < DECODING_CHARS.length) {
                value = DECODING_CHARS[current];
            }
            if (value < 0) {
                throw new IllegalArgumentException("Illegal character '" + current + "'!");
            }
            result |= (long)value << (length - 1 - i) * 5;
        }
        return result;
    }

    static void internalWriteCrockford(char[] buffer, long value, int count, int offset) {
        for (int i = 0; i < count; ++i) {
            int index = (int)(value >>> (count - i - 1) * 5 & 0x1FL);
            buffer[offset + i] = ENCODING_CHARS[index];
        }
    }

    static String internalUIDString(long timeStamp, Random random) {
        char[] buffer = new char[26];
        ULID.internalWriteCrockford(buffer, timeStamp &= 0xFFFFFFFFFFFFL, 10, 0);
        ULID.internalWriteCrockford(buffer, random.nextLong(), 8, 10);
        ULID.internalWriteCrockford(buffer, random.nextLong(), 8, 18);
        return new String(buffer);
    }

    static void internalAppendULID(StringBuilder builder, long timeStamp, Random random) {
        ULID.internalAppendCrockford(builder, timeStamp &= 0xFFFFFFFFFFFFL, 10);
        ULID.internalAppendCrockford(builder, random.nextLong(), 8);
        ULID.internalAppendCrockford(builder, random.nextLong(), 8);
    }

    static Value internalNextValue(long timeStamp, Random random) {
        long mostSignificantBits = random.nextLong();
        long leastSignificantBits = random.nextLong();
        mostSignificantBits &= 0xFFFFL;
        return new Value(mostSignificantBits |= timeStamp << 16, leastSignificantBits);
    }

    public ULID() {
        this(new SecureRandom());
    }

    public ULID(Random random) {
        Objects.requireNonNull(random, "random must not be null!");
        this.random = random;
    }

    public void appendULID(StringBuilder stringBuilder) {
        Objects.requireNonNull(stringBuilder, "stringBuilder must not be null!");
        ULID.internalAppendULID(stringBuilder, System.currentTimeMillis(), this.random);
    }

    public String nextULID() {
        return ULID.internalUIDString(System.currentTimeMillis(), this.random);
    }

    public Value nextValue() {
        return ULID.internalNextValue(System.currentTimeMillis(), this.random);
    }

    public static Value parseULID(String ulidString) {
        Objects.requireNonNull(ulidString, "ulidString must not be null!");
        if (ulidString.length() != 26) {
            throw new IllegalArgumentException("ulidString must be exactly 26 chars long.");
        }
        String timeString = ulidString.substring(0, 10);
        String part1String = ulidString.substring(10, 18);
        String part2String = ulidString.substring(18);
        long time = ULID.internalParseCrockford(timeString);
        long part1 = ULID.internalParseCrockford(part1String);
        long part2 = ULID.internalParseCrockford(part2String);
        long most = time << 16 | part1 >>> 24;
        long least = part2 | part1 << 40;
        return new Value(most, least);
    }

    public static Value fromBytes(byte[] data) {
        int i;
        Objects.requireNonNull(data, "data must not be null!");
        if (data.length != 16) {
            throw new IllegalArgumentException("data must be 16 bytes in length!");
        }
        long mostSignificantBits = 0L;
        long leastSignificantBits = 0L;
        for (i = 0; i < 8; ++i) {
            mostSignificantBits = mostSignificantBits << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            leastSignificantBits = leastSignificantBits << 8 | (long)(data[i] & 0xFF);
        }
        return new Value(mostSignificantBits, leastSignificantBits);
    }

    static {
        for (int i = 0; i < DECODING_CHARS.length; ++i) {
            ULID.DECODING_CHARS[i] = -1;
        }
        ULID.DECODING_CHARS[48] = 0;
        ULID.DECODING_CHARS[79] = 0;
        ULID.DECODING_CHARS[111] = 0;
        ULID.DECODING_CHARS[49] = 1;
        ULID.DECODING_CHARS[73] = 1;
        ULID.DECODING_CHARS[105] = 1;
        ULID.DECODING_CHARS[76] = 1;
        ULID.DECODING_CHARS[108] = 1;
        ULID.DECODING_CHARS[50] = 2;
        ULID.DECODING_CHARS[51] = 3;
        ULID.DECODING_CHARS[52] = 4;
        ULID.DECODING_CHARS[53] = 5;
        ULID.DECODING_CHARS[54] = 6;
        ULID.DECODING_CHARS[55] = 7;
        ULID.DECODING_CHARS[56] = 8;
        ULID.DECODING_CHARS[57] = 9;
        ULID.DECODING_CHARS[65] = 10;
        ULID.DECODING_CHARS[97] = 10;
        ULID.DECODING_CHARS[66] = 11;
        ULID.DECODING_CHARS[98] = 11;
        ULID.DECODING_CHARS[67] = 12;
        ULID.DECODING_CHARS[99] = 12;
        ULID.DECODING_CHARS[68] = 13;
        ULID.DECODING_CHARS[100] = 13;
        ULID.DECODING_CHARS[69] = 14;
        ULID.DECODING_CHARS[101] = 14;
        ULID.DECODING_CHARS[70] = 15;
        ULID.DECODING_CHARS[102] = 15;
        ULID.DECODING_CHARS[71] = 16;
        ULID.DECODING_CHARS[103] = 16;
        ULID.DECODING_CHARS[72] = 17;
        ULID.DECODING_CHARS[104] = 17;
        ULID.DECODING_CHARS[74] = 18;
        ULID.DECODING_CHARS[106] = 18;
        ULID.DECODING_CHARS[75] = 19;
        ULID.DECODING_CHARS[107] = 19;
        ULID.DECODING_CHARS[77] = 20;
        ULID.DECODING_CHARS[109] = 20;
        ULID.DECODING_CHARS[78] = 21;
        ULID.DECODING_CHARS[110] = 21;
        ULID.DECODING_CHARS[80] = 22;
        ULID.DECODING_CHARS[112] = 22;
        ULID.DECODING_CHARS[80] = 22;
        ULID.DECODING_CHARS[112] = 22;
        ULID.DECODING_CHARS[81] = 23;
        ULID.DECODING_CHARS[113] = 23;
        ULID.DECODING_CHARS[82] = 24;
        ULID.DECODING_CHARS[114] = 24;
        ULID.DECODING_CHARS[83] = 25;
        ULID.DECODING_CHARS[115] = 25;
        ULID.DECODING_CHARS[84] = 26;
        ULID.DECODING_CHARS[116] = 26;
        ULID.DECODING_CHARS[86] = 27;
        ULID.DECODING_CHARS[118] = 27;
        ULID.DECODING_CHARS[87] = 28;
        ULID.DECODING_CHARS[119] = 28;
        ULID.DECODING_CHARS[88] = 29;
        ULID.DECODING_CHARS[120] = 29;
        ULID.DECODING_CHARS[89] = 30;
        ULID.DECODING_CHARS[121] = 30;
        ULID.DECODING_CHARS[90] = 31;
        ULID.DECODING_CHARS[122] = 31;
    }

    public static class Value
    implements Comparable<Value>,
    Serializable {
        private static final long serialVersionUID = -3563159514112487717L;
        private final long mostSignificantBits;
        private final long leastSignificantBits;

        public Value(long mostSignificantBits, long leastSignificantBits) {
            this.mostSignificantBits = mostSignificantBits;
            this.leastSignificantBits = leastSignificantBits;
        }

        public long getMostSignificantBits() {
            return this.mostSignificantBits;
        }

        public long getLeastSignificantBits() {
            return this.leastSignificantBits;
        }

        public long timestamp() {
            return this.mostSignificantBits >>> 16;
        }

        public byte[] toBytes() {
            int i;
            byte[] result = new byte[16];
            for (i = 0; i < 8; ++i) {
                result[i] = (byte)(this.mostSignificantBits >> (7 - i) * 8 & 0xFFL);
            }
            for (i = 8; i < 16; ++i) {
                result[i] = (byte)(this.leastSignificantBits >> (15 - i) * 8 & 0xFFL);
            }
            return result;
        }

        public int hashCode() {
            long hilo = this.mostSignificantBits ^ this.leastSignificantBits;
            return (int)(hilo >> 32) ^ (int)hilo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value = (Value)o;
            return this.mostSignificantBits == value.mostSignificantBits && this.leastSignificantBits == value.leastSignificantBits;
        }

        @Override
        public int compareTo(Value val) {
            return this.mostSignificantBits < val.mostSignificantBits ? -1 : (this.mostSignificantBits > val.mostSignificantBits ? 1 : (this.leastSignificantBits < val.leastSignificantBits ? -1 : (this.leastSignificantBits > val.leastSignificantBits ? 1 : 0)));
        }

        public String toString() {
            char[] buffer = new char[26];
            ULID.internalWriteCrockford(buffer, this.timestamp(), 10, 0);
            long value = (this.mostSignificantBits & 0xFFFFL) << 24;
            long interim = this.leastSignificantBits >>> 40;
            ULID.internalWriteCrockford(buffer, value |= interim, 8, 10);
            ULID.internalWriteCrockford(buffer, this.leastSignificantBits, 8, 18);
            return new String(buffer);
        }
    }
}

