/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.spsw.jnhwprovider;

import de.ibapl.spsw.api.SerialPortConfiguration;
import java.io.IOException;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public abstract class AbstractSerialPortSocket<T extends AbstractSerialPortSocket<T>>
extends AbstractInterruptibleChannel
implements SerialPortConfiguration {
    protected final String portName;

    public AbstractSerialPortSocket(String portName) {
        if (portName == null) {
            throw new IllegalArgumentException("portname must not null!");
        }
        this.portName = portName;
    }

    protected void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Port is closed");
        }
    }

    public String getPortName() {
        return this.portName;
    }

    public String toString() {
        try {
            return String.format("[portname=%s, speed= %s, dataBits= %s, stopBits= %s, parity= %s, flowControl= %s]", this.getPortName(), this.getSpeed(), this.getDatatBits(), this.getStopBits(), this.getParity(), this.getFlowControl());
        }
        catch (IOException e) {
            return "Internal Error " + e;
        }
    }
}

