/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.spsw.jnhwprovider;

import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.Int32_t;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.libloader.LoadState;
import de.ibapl.jnhw.util.winapi.LibJnhwWinApiLoader;
import de.ibapl.jnhw.winapi.Fileapi;
import de.ibapl.jnhw.winapi.Handleapi;
import de.ibapl.jnhw.winapi.Ioapiset;
import de.ibapl.jnhw.winapi.Minwinbase;
import de.ibapl.jnhw.winapi.Synchapi;
import de.ibapl.jnhw.winapi.WinDef;
import de.ibapl.jnhw.winapi.Winbase;
import de.ibapl.jnhw.winapi.Winnt;
import de.ibapl.jnhw.winapi.Winreg;
import de.ibapl.spsw.api.DataBits;
import de.ibapl.spsw.api.FlowControl;
import de.ibapl.spsw.api.Parity;
import de.ibapl.spsw.api.Speed;
import de.ibapl.spsw.api.StopBits;
import de.ibapl.spsw.api.TimeoutIOException;
import de.ibapl.spsw.jnhwprovider.StreamSerialPortSocket;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenericWinSerialPortSocket
extends StreamSerialPortSocket<GenericWinSerialPortSocket> {
    public static final Cleaner CLEANER = Cleaner.create();
    private static final Logger LOG = Logger.getLogger(GenericWinSerialPortSocket.class.getCanonicalName());
    private volatile Winnt.HANDLE hFile = Winnt.HANDLE.INVALID_HANDLE_VALUE;
    private final HFileCleaner cleaner = new HFileCleaner();
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Minwinbase.OVERLAPPED readOverlapped = new Minwinbase.OVERLAPPED();
    private final Minwinbase.OVERLAPPED writeOverlapped = new Minwinbase.OVERLAPPED();
    private Winnt.HANDLE readEvent = Winnt.HANDLE.INVALID_HANDLE_VALUE;
    private Winnt.HANDLE writeEvent = Winnt.HANDLE.INVALID_HANDLE_VALUE;
    private ExecutorService executor;

    private void setReadEvent(Winnt.HANDLE readEvent) {
        this.readEvent = readEvent;
        this.readOverlapped.hEvent(readEvent);
    }

    private void setWriteEvent(Winnt.HANDLE writeEvent) {
        this.writeEvent = writeEvent;
        this.writeOverlapped.hEvent(writeEvent);
    }

    public static List<String> getWindowsBasedPortNames() {
        WinDef.RegistryHKEY phkResult;
        if (LoadState.SUCCESS != LibJnhwWinApiLoader.touch()) {
            throw new RuntimeException("Could not load native lib", LibJnhwWinApiLoader.getLoadResult().loadError);
        }
        LinkedList<String> result = new LinkedList<String>();
        String lpSubKey = "HARDWARE\\DEVICEMAP\\SERIALCOMM\\";
        try {
            phkResult = Winreg.RegOpenKeyExW((WinDef.HKEY)Winreg.HKEY_LOCAL_MACHINE, (String)lpSubKey, (int)0, (int)131097);
        }
        catch (NativeErrorException nee) {
            throw new RuntimeException("Could not open registry errorCode: " + nee.errno, nee);
        }
        int dwIndex = 0;
        Winnt.LPWSTR lpValueName = new Winnt.LPWSTR(256, AbstractNativeMemory.SetMem.DO_NOT_SET);
        WinDef.LPBYTE lpData = new WinDef.LPBYTE(256, AbstractNativeMemory.SetMem.DO_NOT_SET);
        WinDef.LPDWORD lpcchValueName = new WinDef.LPDWORD();
        WinDef.LPDWORD lpccData = new WinDef.LPDWORD();
        WinDef.LPDWORD lpType = new WinDef.LPDWORD();
        boolean collecting = true;
        do {
            try {
                long errorCode = Winreg.RegEnumValueW((WinDef.HKEY)phkResult, (int)dwIndex, (Winnt.LPWSTR)lpValueName, (WinDef.LPDWORD)lpcchValueName, (WinDef.LPDWORD)lpType, (WinDef.LPBYTE)lpData, (WinDef.LPDWORD)lpccData);
                if (errorCode == 0L) {
                    result.add(WinDef.LPBYTE.getUnicodeString((WinDef.LPBYTE)lpData, (boolean)true, (int)lpccData.uint32_t()));
                    ++dwIndex;
                    lpValueName.clear();
                    continue;
                }
                if (errorCode == 259L) {
                    collecting = false;
                    continue;
                }
                throw new RuntimeException("Should never happen! Unknown Error in getWindowsBasedPortNames RegEnumValueW errorCode: " + errorCode);
            }
            catch (NativeErrorException nee) {
                throw new RuntimeException("Unknown Error in getWindowsBasedPortNames RegEnumValueW errorCode: " + nee.errno);
            }
        } while (collecting);
        try {
            Winreg.RegCloseKey((WinDef.HKEY)phkResult);
        }
        catch (NativeErrorException nativeErrorException) {
            // empty catch block
        }
        return result;
    }

    GenericWinSerialPortSocket(String portName) throws IOException {
        this(portName, null, null, null, null, null);
    }

    GenericWinSerialPortSocket(String portName, Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls) throws IOException {
        super(portName);
        if (LoadState.SUCCESS != LibJnhwWinApiLoader.touch()) {
            throw new RuntimeException("Could not load native lib", LibJnhwWinApiLoader.getLoadResult().loadError);
        }
        this.open(speed, dataBits, stopBits, parity, flowControls);
    }

    public GenericWinSerialPortSocket(String portName, ExecutorService executor) throws IOException {
        this(portName);
        this.executor = executor;
    }

    public GenericWinSerialPortSocket(String portName, Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls, ExecutorService executor) throws IOException {
        this(portName, speed, dataBits, stopBits, parity, flowControls);
        this.executor = executor;
    }

    private IOException createClosedOrNativeException(int errno, String formatString, Object ... args) {
        if (this.hFile.isNot_INVALID_HANDLE_VALUE()) {
            return new IOException(String.format("Native port error on %s, \"%d\" %s", this.portName, errno, String.format(formatString, args)));
        }
        return new IOException("Port is closed");
    }

    private Winbase.DCB getDCB() throws IOException {
        Winbase.DCB result = new Winbase.DCB(AbstractNativeMemory.SetMem.TO_0x00);
        try {
            Winbase.GetCommState((Winnt.HANDLE)this.hFile, (Winbase.DCB)result);
            return result;
        }
        catch (NativeErrorException nee) {
            throw this.createClosedOrNativeException(nee.errno, "GetCommState (%s)", this.portName);
        }
    }

    private DataBits getDatatBits(Winbase.DCB dcb) throws IOException {
        switch (dcb.ByteSize()) {
            case 5: {
                return DataBits.DB_5;
            }
            case 6: {
                return DataBits.DB_6;
            }
            case 7: {
                return DataBits.DB_7;
            }
            case 8: {
                return DataBits.DB_8;
            }
        }
        throw new IllegalArgumentException("getDataBits Unknown databits");
    }

    public DataBits getDatatBits() throws IOException {
        return this.getDatatBits(this.getDCB());
    }

    public Set<FlowControl> getFlowControl() throws IOException {
        return this.getFlowControl(this.getDCB());
    }

    private Set<FlowControl> getFlowControl(Winbase.DCB dcb) throws IOException {
        EnumSet<FlowControl> result = EnumSet.noneOf(FlowControl.class);
        if (dcb.fRtsControl() == 3) {
            result.add(FlowControl.RTS_CTS_IN);
        }
        if (dcb.fOutxCtsFlow()) {
            result.add(FlowControl.RTS_CTS_OUT);
        }
        if (dcb.fInX()) {
            result.add(FlowControl.XON_XOFF_IN);
        }
        if (dcb.fOutX()) {
            result.add(FlowControl.XON_XOFF_OUT);
        }
        return result;
    }

    private Winbase.COMSTAT getCOMSTAT() throws IOException {
        Int32_t lpErrors = new Int32_t();
        OpaqueMemory32.clear((OpaqueMemory32)lpErrors);
        Winbase.COMSTAT result = new Winbase.COMSTAT(AbstractNativeMemory.SetMem.TO_0x00);
        try {
            Winbase.ClearCommError((Winnt.HANDLE)this.hFile, (Int32_t)lpErrors, (Winbase.COMSTAT)result);
            return result;
        }
        catch (NativeErrorException nee) {
            throw this.createClosedOrNativeException(nee.errno, "native call ClearCommError lpError 0x%08x", lpErrors.int32_t());
        }
    }

    private Winbase.COMMTIMEOUTS getCOMMTIMEOUTS() throws IOException {
        Winbase.COMMTIMEOUTS result = new Winbase.COMMTIMEOUTS(AbstractNativeMemory.SetMem.TO_0x00);
        try {
            Winbase.GetCommTimeouts((Winnt.HANDLE)this.hFile, (Winbase.COMMTIMEOUTS)result);
            return result;
        }
        catch (NativeErrorException nee) {
            throw this.createClosedOrNativeException(nee.errno, "native call to GetCommTimeouts", new Object[0]);
        }
    }

    public int getInBufferBytesCount() throws IOException {
        return this.getCOMSTAT().cbInQue();
    }

    public int getInterByteReadTimeout() throws IOException {
        Winbase.COMMTIMEOUTS lpCommTimeouts = this.getCOMMTIMEOUTS();
        if ((lpCommTimeouts.ReadIntervalTimeout() & lpCommTimeouts.ReadTotalTimeoutMultiplier() & 0xFFFFFFFFL) == 0xFFFFFFFFL) {
            return 0;
        }
        int result = (int)lpCommTimeouts.ReadIntervalTimeout();
        if (result < 0) {
            throw new RuntimeException("COMMTIMEOUTS.ReadIntervalTimeout overflow from long to int occured");
        }
        return result;
    }

    public int getOutBufferBytesCount() throws IOException {
        return this.getCOMSTAT().cbOutQue();
    }

    public int getOverallReadTimeout() throws IOException {
        int result = (int)this.getCOMMTIMEOUTS().ReadTotalTimeoutConstant();
        if (result < 0) {
            throw new RuntimeException("COMMTIMEOUTS.ReadTotalTimeoutConstant overflow from long to int occured");
        }
        return result;
    }

    public int getOverallWriteTimeout() throws IOException {
        int result = (int)this.getCOMMTIMEOUTS().WriteTotalTimeoutConstant();
        if (result < 0) {
            throw new RuntimeException("COMMTIMEOUTS.WriteTotalTimeoutConstant overflow from long to int occured");
        }
        return result;
    }

    public Parity getParity() throws IOException {
        return this.getParity(this.getDCB().Parity());
    }

    private Parity getParity(byte parity) throws IOException {
        if (parity == 0) {
            return Parity.NONE;
        }
        if (parity == 1) {
            return Parity.ODD;
        }
        if (parity == 2) {
            return Parity.EVEN;
        }
        if (parity == 3) {
            return Parity.MARK;
        }
        if (parity == 4) {
            return Parity.SPACE;
        }
        throw new IllegalArgumentException("getParity unknown Parity");
    }

    public Speed getSpeed() throws IOException {
        return this.getSpeed(this.getDCB());
    }

    private Speed getSpeed(Winbase.DCB dcb) throws IOException {
        switch (dcb.BaudRate()) {
            case 0: {
                return Speed._0_BPS;
            }
            case 50: {
                return Speed._50_BPS;
            }
            case 75: {
                return Speed._75_BPS;
            }
            case 110: {
                return Speed._110_BPS;
            }
            case 134: {
                return Speed._134_BPS;
            }
            case 150: {
                return Speed._150_BPS;
            }
            case 200: {
                return Speed._200_BPS;
            }
            case 300: {
                return Speed._300_BPS;
            }
            case 600: {
                return Speed._600_BPS;
            }
            case 1200: {
                return Speed._1200_BPS;
            }
            case 1800: {
                return Speed._1800_BPS;
            }
            case 2400: {
                return Speed._2400_BPS;
            }
            case 4800: {
                return Speed._4800_BPS;
            }
            case 9600: {
                return Speed._9600_BPS;
            }
            case 19200: {
                return Speed._19200_BPS;
            }
            case 38400: {
                return Speed._38400_BPS;
            }
            case 57600: {
                return Speed._57600_BPS;
            }
            case 115200: {
                return Speed._115200_BPS;
            }
            case 230400: {
                return Speed._230400_BPS;
            }
            case 460800: {
                return Speed._460800_BPS;
            }
            case 500000: {
                return Speed._500000_BPS;
            }
            case 576000: {
                return Speed._576000_BPS;
            }
            case 921600: {
                return Speed._921600_BPS;
            }
            case 1000000: {
                return Speed._1000000_BPS;
            }
            case 1152000: {
                return Speed._1152000_BPS;
            }
            case 1500000: {
                return Speed._1500000_BPS;
            }
            case 2000000: {
                return Speed._2000000_BPS;
            }
            case 2500000: {
                return Speed._2500000_BPS;
            }
            case 3000000: {
                return Speed._3000000_BPS;
            }
            case 3500000: {
                return Speed._3500000_BPS;
            }
            case 4000000: {
                return Speed._4000000_BPS;
            }
        }
        throw new IllegalArgumentException("getSpeed Speed not supported");
    }

    public StopBits getStopBits() throws IOException {
        return this.getStopBits(this.getDCB().StopBits());
    }

    private StopBits getStopBits(byte stopBits) throws IOException {
        if (stopBits == 0) {
            return StopBits.SB_1;
        }
        if (stopBits == 1) {
            return StopBits.SB_1_5;
        }
        if (stopBits == 2) {
            return StopBits.SB_2;
        }
        throw new IllegalArgumentException("getStopBits Unknown stopbits");
    }

    public char getXOFFChar() throws IOException {
        return this.getDCB().XoffChar();
    }

    public char getXONChar() throws IOException {
        return this.getDCB().XonChar();
    }

    @Override
    protected void implCloseChannel() throws IOException {
        Winnt.HANDLE hEvent;
        Winnt.HANDLE _hFile;
        block8: {
            super.implCloseChannel();
            _hFile = this.hFile;
            this.hFile = Winnt.HANDLE.INVALID_HANDLE_VALUE;
            try {
                Ioapiset.CancelIo((Winnt.HANDLE)_hFile);
            }
            catch (NativeErrorException nee) {
                if (nee.errno == 1168) break block8;
                this.hFile = _hFile;
                throw new IOException("Can't cancel IO for closing", nee);
            }
        }
        try {
            Handleapi.CloseHandle((Winnt.HANDLE)_hFile);
            this.cleaner.hFile = Winnt.HANDLE.INVALID_HANDLE_VALUE;
        }
        catch (NativeErrorException nee) {
            throw new IOException("Can't close port", nee);
        }
        try {
            hEvent = this.readEvent;
            this.setReadEvent(Winnt.HANDLE.INVALID_HANDLE_VALUE);
            Handleapi.CloseHandle((Winnt.HANDLE)hEvent);
            this.cleaner.readEvent = Winnt.HANDLE.INVALID_HANDLE_VALUE;
        }
        catch (NativeErrorException nee) {
            LOG.log(Level.SEVERE, "can't properly close readEvent " + nee.errno, nee);
        }
        try {
            hEvent = this.writeEvent;
            this.setWriteEvent(Winnt.HANDLE.INVALID_HANDLE_VALUE);
            Handleapi.CloseHandle((Winnt.HANDLE)hEvent);
            this.cleaner.writeEvent = Winnt.HANDLE.INVALID_HANDLE_VALUE;
        }
        catch (NativeErrorException nee) {
            LOG.log(Level.SEVERE, "can't properly close writeEvent " + nee.errno, nee);
        }
    }

    private boolean getCommModemStatus(int bitMask) throws IOException {
        Int32_t lpModemStat = new Int32_t();
        OpaqueMemory32.clear((OpaqueMemory32)lpModemStat);
        try {
            Winbase.GetCommModemStatus((Winnt.HANDLE)this.hFile, (Int32_t)lpModemStat);
            return (lpModemStat.int32_t() & bitMask) == bitMask;
        }
        catch (NativeErrorException nee) {
            throw this.createClosedOrNativeException(nee.errno, "Can't get GetCommModemStatus", new Object[0]);
        }
    }

    public boolean isCTS() throws IOException {
        return this.getCommModemStatus(16);
    }

    public boolean isDCD() throws IOException {
        return this.getCommModemStatus(128);
    }

    public boolean isDSR() throws IOException {
        return this.getCommModemStatus(32);
    }

    public boolean isRI() throws IOException {
        return this.getCommModemStatus(64);
    }

    private void setParams(Winbase.DCB dcb, Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls) throws IOException {
        if (speed != null) {
            dcb.BaudRate(speed.value);
        }
        if (dataBits != null) {
            dcb.ByteSize((byte)dataBits.value);
            switch (dataBits) {
                case DB_5: {
                    if (dcb.StopBits() != 2) break;
                    dcb.StopBits((byte)1);
                    break;
                }
                case DB_6: 
                case DB_7: 
                case DB_8: {
                    if (dcb.StopBits() != 1) break;
                    dcb.StopBits((byte)2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("setParams Wrong databits: " + dataBits);
                }
            }
        }
        if (stopBits != null) {
            switch (stopBits) {
                case SB_1: {
                    dcb.StopBits((byte)0);
                    break;
                }
                case SB_1_5: {
                    if (dcb.ByteSize() == 5) {
                        dcb.StopBits((byte)1);
                        break;
                    }
                    throw new IllegalArgumentException("setParams setStopBits to 1.5: only for 5 dataBits 1.5 stoppbits are supported");
                }
                case SB_2: {
                    if (dcb.ByteSize() == 5) {
                        throw new IllegalArgumentException("setParams setStopBits to 2: 5 dataBits only 1.5 stoppbits are supported");
                    }
                    dcb.StopBits((byte)2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("setParams Unknown stopbits");
                }
            }
        }
        if (parity != null) {
            switch (parity) {
                case NONE: {
                    dcb.Parity((byte)0);
                    break;
                }
                case ODD: {
                    dcb.Parity((byte)1);
                    break;
                }
                case EVEN: {
                    dcb.Parity((byte)2);
                    break;
                }
                case MARK: {
                    dcb.Parity((byte)3);
                    break;
                }
                case SPACE: {
                    dcb.Parity((byte)4);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("setParams Wrong Parity");
                }
            }
        }
        if (flowControls != null) {
            dcb.fRtsControl((byte)0);
            dcb.fOutxCtsFlow(false);
            dcb.fOutX(false);
            dcb.fInX(false);
            if (flowControls.contains(FlowControl.RTS_CTS_IN)) {
                dcb.fRtsControl((byte)3);
            }
            if (flowControls.contains(FlowControl.RTS_CTS_OUT)) {
                dcb.fOutxCtsFlow(true);
            }
            if (flowControls.contains(FlowControl.XON_XOFF_IN)) {
                dcb.fInX(true);
            }
            if (flowControls.contains(FlowControl.XON_XOFF_OUT)) {
                dcb.fOutX(true);
            }
        }
        try {
            Winbase.SetCommState((Winnt.HANDLE)this.hFile, (Winbase.DCB)dcb);
        }
        catch (NativeErrorException nee) {
            switch (nee.errno) {
                case 87: {
                    throw new IllegalArgumentException("setParams: Wrong params\n GetLastError() == ERROR_INVALID_PARAMETER");
                }
                case 31: {
                    throw new IllegalArgumentException("setParams: Wrong params\n GetLastError() == ERROR_GEN_FAILURE");
                }
            }
            throw this.createClosedOrNativeException(nee.errno, "setParams SetCommState", new Object[0]);
        }
        StringBuilder errorMsgs = new StringBuilder();
        Winbase.DCB readed = this.getDCB();
        if (speed != null && speed != this.getSpeed(dcb)) {
            errorMsgs.append("Could not set speed!\n");
        }
        if (dataBits != null && dataBits != this.getDatatBits(dcb)) {
            errorMsgs.append("Could not set dataBits!\n");
        }
        if (stopBits != null && stopBits != this.getStopBits(dcb.StopBits())) {
            errorMsgs.append("Could not set stopBits!\n");
        }
        if (parity != null && parity != this.getParity(dcb.Parity())) {
            errorMsgs.append("Could not set parity!\n");
        }
        if (flowControls != null && !flowControls.equals(this.getFlowControl(dcb))) {
            errorMsgs.append("Could not set flowControl!");
        }
        if (errorMsgs.length() > 0) {
            throw new IllegalArgumentException(errorMsgs.toString());
        }
    }

    private void open(Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls) throws IOException {
        if (this.hFile.isNot_INVALID_HANDLE_VALUE()) {
            throw new IOException("Port is open");
        }
        String portFullName = "\\\\.\\" + this.portName;
        try {
            this.hFile = Fileapi.CreateFileW((String)portFullName, (int)-1073741824, (int)0, null, (int)3, (int)0x40000000, null);
        }
        catch (NativeErrorException nee) {
            if (nee.errno == 5) {
                throw new IOException(String.format("Port is busy: \"%s\"", this.portName));
            }
            if (nee.errno == -2005336062) {
                throw new IOException(String.format("Port not found: \"%s\"", this.portName));
            }
            throw new IOException(String.format("Open: Unknown port error %d", nee.errno));
        }
        Winbase.DCB dcb = new Winbase.DCB(AbstractNativeMemory.SetMem.TO_0x00);
        try {
            Winbase.GetCommState((Winnt.HANDLE)this.hFile, (Winbase.DCB)dcb);
        }
        catch (NativeErrorException nee) {
            try {
                Handleapi.CloseHandle((Winnt.HANDLE)this.hFile);
            }
            catch (NativeErrorException nativeErrorException) {
                // empty catch block
            }
            this.hFile = Winnt.HANDLE.INVALID_HANDLE_VALUE;
            throw new IOException(String.format("Not a serial port: \"%s\"", this.portName));
        }
        try {
            this.setParams(dcb, speed, dataBits, stopBits, parity, flowControls);
        }
        catch (Throwable t) {
            try {
                Handleapi.CloseHandle((Winnt.HANDLE)this.hFile);
            }
            catch (NativeErrorException nativeErrorException) {
                // empty catch block
            }
            this.hFile = Winnt.HANDLE.INVALID_HANDLE_VALUE;
            throw t;
        }
        Winbase.COMMTIMEOUTS lpCommTimeouts = new Winbase.COMMTIMEOUTS(AbstractNativeMemory.SetMem.TO_0x00);
        try {
            Winbase.GetCommTimeouts((Winnt.HANDLE)this.hFile, (Winbase.COMMTIMEOUTS)lpCommTimeouts);
        }
        catch (NativeErrorException nee) {
            try {
                Handleapi.CloseHandle((Winnt.HANDLE)this.hFile);
            }
            catch (NativeErrorException nativeErrorException) {
                // empty catch block
            }
            this.hFile = Winnt.HANDLE.INVALID_HANDLE_VALUE;
            throw new IOException("Open GetCommTimeouts");
        }
        lpCommTimeouts.ReadIntervalTimeout(100L);
        lpCommTimeouts.ReadTotalTimeoutConstant(0L);
        lpCommTimeouts.ReadTotalTimeoutMultiplier(0L);
        lpCommTimeouts.WriteTotalTimeoutConstant(0L);
        lpCommTimeouts.WriteTotalTimeoutMultiplier(0L);
        try {
            Winbase.SetCommTimeouts((Winnt.HANDLE)this.hFile, (Winbase.COMMTIMEOUTS)lpCommTimeouts);
        }
        catch (NativeErrorException nee) {
            try {
                Handleapi.CloseHandle((Winnt.HANDLE)this.hFile);
            }
            catch (NativeErrorException nativeErrorException) {
                // empty catch block
            }
            this.hFile = Winnt.HANDLE.INVALID_HANDLE_VALUE;
            throw new IOException("Open SetCommTimeouts");
        }
        CLEANER.register(this, this.cleaner);
        this.cleaner.hFile = this.hFile;
        try {
            this.setReadEvent(Synchapi.CreateEventW(null, (boolean)true, (boolean)false, null));
            this.cleaner.readEvent = this.readEvent;
        }
        catch (NativeErrorException nee) {
            throw new RuntimeException("Can't create readEvent error: " + nee.errno, nee);
        }
        try {
            this.setWriteEvent(Synchapi.CreateEventW(null, (boolean)true, (boolean)false, null));
            this.cleaner.writeEvent = this.writeEvent;
        }
        catch (NativeErrorException nee) {
            throw new RuntimeException("Can't create writeEvent error: " + nee.errno, nee);
        }
    }

    public void sendBreak(int duration) throws IOException {
        if (duration <= 0) {
            throw new IllegalArgumentException("sendBreak duration must be grater than 0");
        }
        try {
            Winbase.SetCommBreak((Winnt.HANDLE)this.hFile);
        }
        catch (NativeErrorException nee) {
            throw this.createClosedOrNativeException(nee.errno, "sendBreak SetCommBreak", new Object[0]);
        }
        boolean completed = false;
        try {
            Thread.sleep(duration);
            completed = true;
        }
        catch (InterruptedException ex) {
            Logger.getLogger(GenericWinSerialPortSocket.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            Winbase.ClearCommBreak((Winnt.HANDLE)this.hFile);
        }
        catch (NativeErrorException nee) {
            throw this.createClosedOrNativeException(nee.errno, "sendBreak ClearCommBreak", new Object[0]);
        }
        if (!completed) {
            this.close();
            throw new AsynchronousCloseException();
        }
    }

    public void sendXOFF() throws IOException {
        throw new IOException("sendXOFF not implemented yet");
    }

    public void sendXON() throws IOException {
        throw new IOException("sendXON not implemented yet");
    }

    public void setBreak(boolean value) throws IOException {
        int dwFunc = value ? 8 : 9;
        try {
            Winbase.EscapeCommFunction((Winnt.HANDLE)this.hFile, (int)dwFunc);
        }
        catch (NativeErrorException nee) {
            if (nee.errno == 87) {
                throw new IllegalArgumentException("setBreak: Wrong value");
            }
            throw this.createClosedOrNativeException(nee.errno, "Can't set/clear BREAK", new Object[0]);
        }
    }

    public void setDataBits(DataBits dataBits) throws IOException {
        this.setParams(this.getDCB(), null, dataBits, null, null, null);
    }

    public void setDTR(boolean value) throws IOException {
        int dwFunc = value ? 5 : 6;
        try {
            Winbase.EscapeCommFunction((Winnt.HANDLE)this.hFile, (int)dwFunc);
        }
        catch (NativeErrorException nee) {
            if (nee.errno == 87) {
                throw new IllegalArgumentException("setDTR: Wrong value");
            }
            throw this.createClosedOrNativeException(nee.errno, "Can't set/clear DTR", new Object[0]);
        }
    }

    public void setFlowControl(Set<FlowControl> flowControls) throws IOException {
        this.setParams(this.getDCB(), null, null, null, null, flowControls);
    }

    public void setParity(Parity parity) throws IOException {
        this.setParams(this.getDCB(), null, null, null, parity, null);
    }

    public void setRTS(boolean value) throws IOException {
        int dwFunc = value ? 3 : 4;
        try {
            Winbase.EscapeCommFunction((Winnt.HANDLE)this.hFile, (int)dwFunc);
        }
        catch (NativeErrorException nee) {
            if (nee.errno == 87) {
                throw new IllegalArgumentException("setRTS: Wrong value");
            }
            throw this.createClosedOrNativeException(nee.errno, "Can't set/clear RTS", new Object[0]);
        }
    }

    public void setSpeed(Speed speed) throws IOException {
        this.setParams(this.getDCB(), speed, null, null, null, null);
    }

    public void setStopBits(StopBits stopBits) throws IOException {
        this.setParams(this.getDCB(), null, null, stopBits, null, null);
    }

    public void setTimeouts(int interByteReadTimeout, int overallReadTimeout, int overallWriteTimeout) throws IOException {
        if (overallWriteTimeout < 0) {
            throw new IllegalArgumentException("setTimeouts: overallWriteTimeout must >= 0");
        }
        if (overallReadTimeout < 0) {
            throw new IllegalArgumentException("setTimeouts: overallReadTimeout must >= 0");
        }
        if (interByteReadTimeout < 0) {
            throw new IllegalArgumentException("setReadTimeouts: interByteReadTimeout must >= 0");
        }
        Winbase.COMMTIMEOUTS commTimeouts = new Winbase.COMMTIMEOUTS(AbstractNativeMemory.SetMem.TO_0x00);
        if (interByteReadTimeout == 0 && overallReadTimeout > 0) {
            commTimeouts.ReadIntervalTimeout(0xFFFFFFFFL);
            commTimeouts.ReadTotalTimeoutMultiplier(0xFFFFFFFFL);
            commTimeouts.ReadTotalTimeoutConstant((long)overallReadTimeout);
        } else {
            commTimeouts.ReadIntervalTimeout((long)interByteReadTimeout);
            commTimeouts.ReadTotalTimeoutMultiplier(0L);
            commTimeouts.ReadTotalTimeoutConstant((long)overallReadTimeout);
        }
        commTimeouts.WriteTotalTimeoutMultiplier(0L);
        commTimeouts.WriteTotalTimeoutConstant((long)overallWriteTimeout);
        try {
            Winbase.SetCommTimeouts((Winnt.HANDLE)this.hFile, (Winbase.COMMTIMEOUTS)commTimeouts);
        }
        catch (NativeErrorException nee) {
            if (nee.errno == 87) {
                throw new IllegalArgumentException("setTimeouts: Wrong Timeouts");
            }
            throw this.createClosedOrNativeException(nee.errno, "setTimeouts SetCommTimeouts", new Object[0]);
        }
    }

    public void setXOFFChar(char c) throws IOException {
        Winbase.DCB dcb = new Winbase.DCB(AbstractNativeMemory.SetMem.TO_0x00);
        try {
            Winbase.GetCommState((Winnt.HANDLE)this.hFile, (Winbase.DCB)dcb);
        }
        catch (NativeErrorException nee) {
            throw this.createClosedOrNativeException(nee.errno, "setXOFFChar GetCommState", new Object[0]);
        }
        dcb.XoffChar(c);
        try {
            Winbase.SetCommState((Winnt.HANDLE)this.hFile, (Winbase.DCB)dcb);
        }
        catch (NativeErrorException nee) {
            if (nee.errno == 87) {
                throw new IllegalArgumentException("etXOFFChar: Wrong value\n GetLastError() == ERROR_INVALID_PARAMETER");
            }
            if (nee.errno == 31) {
                throw new IllegalArgumentException("etXOFFChar: Wrong value\n GetLastError() == ERROR_GEN_FAILURE");
            }
            throw this.createClosedOrNativeException(nee.errno, "setXOFFChar SetCommState", new Object[0]);
        }
    }

    public void setXONChar(char c) throws IOException {
        Winbase.DCB dcb = new Winbase.DCB(AbstractNativeMemory.SetMem.TO_0x00);
        try {
            Winbase.GetCommState((Winnt.HANDLE)this.hFile, (Winbase.DCB)dcb);
        }
        catch (NativeErrorException nee) {
            throw this.createClosedOrNativeException(nee.errno, "setXONChar GetCommState", new Object[0]);
        }
        dcb.XonChar(c);
        try {
            Winbase.SetCommState((Winnt.HANDLE)this.hFile, (Winbase.DCB)dcb);
        }
        catch (NativeErrorException nee) {
            if (nee.errno == 87) {
                throw new IllegalArgumentException("setXONChar: Wrong value\n GetLastError() == ERROR_INVALID_PARAMETER");
            }
            if (nee.errno == 31) {
                throw new IllegalArgumentException("setXONChar: Wrong value\n GetLastError() == ERROR_GEN_FAILURE");
            }
            throw this.createClosedOrNativeException(nee.errno, "setXONChar SetCommState", new Object[0]);
        }
    }

    public void drainOutputBuffer() throws IOException {
        boolean completed = false;
        try {
            this.begin();
            try {
                Fileapi.FlushFileBuffers((Winnt.HANDLE)this.hFile);
                completed = true;
            }
            catch (NativeErrorException nee) {
                completed = true;
                throw this.createClosedOrNativeException(nee.errno, "drainOutputBuffer", new Object[0]);
            }
        }
        finally {
            this.end(completed);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer dst) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            block22: {
                if (!dst.hasRemaining()) {
                    return 0;
                }
                try {
                    Synchapi.ResetEvent((Winnt.HANDLE)this.readEvent);
                }
                catch (NativeErrorException nee) {
                    throw new IOException("Error read => ResetEvent: " + nee.errno, nee);
                }
                try {
                    Fileapi.ReadFile((Winnt.HANDLE)this.hFile, (ByteBuffer)dst, (Minwinbase.OVERLAPPED)this.readOverlapped);
                }
                catch (NativeErrorException nee) {
                    if (nee.errno == 997) break block22;
                    if (this.hFile.isNot_INVALID_HANDLE_VALUE()) {
                        throw new InterruptedIOException("Error readBytes(GetLastError):" + nee.errno);
                    }
                    throw new AsynchronousCloseException();
                }
            }
            boolean completed = false;
            try {
                this.begin();
                try {
                    long waitResult = Synchapi.WaitForSingleObject((Winnt.HANDLE)this.readEvent, (long)-1L);
                    if (waitResult != 0L) {
                        if (this.hFile.isNot_INVALID_HANDLE_VALUE()) {
                            completed = true;
                            throw new InterruptedIOException("Error readBytes (WaitForSingleObject): " + waitResult);
                        }
                        completed = true;
                        throw new AsynchronousCloseException();
                    }
                }
                catch (NativeErrorException nee1) {
                    completed = true;
                    throw new RuntimeException("NativeError readBytes (WaitForSingleObject)", nee1);
                }
                int dwBytesRead = 0;
                try {
                    dwBytesRead = Ioapiset.GetOverlappedResult((Winnt.HANDLE)this.hFile, (Minwinbase.OVERLAPPED)this.readOverlapped, (ByteBuffer)dst, (boolean)false);
                }
                catch (NativeErrorException nee) {
                    if (this.hFile.isNot_INVALID_HANDLE_VALUE()) {
                        InterruptedIOException iioe = new InterruptedIOException("Error readBytes (GetOverlappedResult)");
                        completed = true;
                        throw iioe;
                    }
                    completed = true;
                    throw new AsynchronousCloseException();
                }
                if (dwBytesRead > 0) {
                    completed = true;
                    int nee = dwBytesRead;
                    return nee;
                }
                if (dwBytesRead == 0) {
                    if (this.hFile.isNot_INVALID_HANDLE_VALUE()) {
                        TimeoutIOException tioe = new TimeoutIOException("read dwBytesRead == 0");
                        tioe.bytesTransferred = dwBytesRead;
                        completed = true;
                        throw tioe;
                    }
                    completed = true;
                    throw new AsynchronousCloseException();
                }
                completed = true;
                throw new InterruptedIOException("Should never happen! readBytes dwBytes < 0");
            }
            finally {
                this.end(completed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            int n;
            block21: {
                if (!src.hasRemaining()) {
                    return 0;
                }
                try {
                    Synchapi.ResetEvent((Winnt.HANDLE)this.writeEvent);
                }
                catch (NativeErrorException nee) {
                    throw new IOException("Error write => ResetEvent: " + nee.errno, nee);
                }
                try {
                    Fileapi.WriteFile((Winnt.HANDLE)this.hFile, (ByteBuffer)src, (Minwinbase.OVERLAPPED)this.writeOverlapped);
                }
                catch (NativeErrorException nee) {
                    if (nee.errno == 997) break block21;
                    if (this.hFile.isNot_INVALID_HANDLE_VALUE()) {
                        throw new InterruptedIOException("Error writeBytes (GetLastError): " + nee.errno);
                    }
                    throw new AsynchronousCloseException();
                }
            }
            boolean completed = false;
            try {
                this.begin();
                try {
                    long waitResult = Synchapi.WaitForSingleObject((Winnt.HANDLE)this.writeEvent, (long)-1L);
                    if (waitResult != 0L) {
                        if (this.hFile.isNot_INVALID_HANDLE_VALUE()) {
                            completed = true;
                            throw new InterruptedIOException("Error writeBytes (WaitForSingleObject): " + waitResult);
                        }
                        completed = true;
                        throw new AsynchronousCloseException();
                    }
                }
                catch (NativeErrorException nee1) {
                    completed = true;
                    throw new RuntimeException("NativeError writeBytes (WaitForSingleObject)", nee1);
                }
                int dwBytesWritten = 0;
                try {
                    dwBytesWritten = Ioapiset.GetOverlappedResult((Winnt.HANDLE)this.hFile, (Minwinbase.OVERLAPPED)this.writeOverlapped, (ByteBuffer)src, (boolean)false);
                }
                catch (NativeErrorException nee) {
                    if (this.hFile.isNot_INVALID_HANDLE_VALUE()) {
                        InterruptedIOException iioe = new InterruptedIOException("Error writeBytes (GetOverlappedResult) errno: " + nee.errno);
                        completed = true;
                        throw iioe;
                    }
                    completed = true;
                    throw new AsynchronousCloseException();
                }
                if (src.hasRemaining()) {
                    if (this.hFile.isNot_INVALID_HANDLE_VALUE()) {
                        InterruptedIOException iioe = new InterruptedIOException("Error writeBytes too view written");
                        iioe.bytesTransferred = dwBytesWritten;
                        completed = true;
                        throw iioe;
                    }
                    completed = true;
                    throw new AsynchronousCloseException();
                }
                completed = true;
                n = dwBytesWritten;
            }
            catch (Throwable throwable) {
                this.end(completed);
                throw throwable;
            }
            this.end(completed);
            return n;
        }
    }

    static class HFileCleaner
    implements Runnable {
        Winnt.HANDLE hFile = Handleapi.INVALID_HANDLE_VALUE;
        Winnt.HANDLE readEvent = Handleapi.INVALID_HANDLE_VALUE;
        Winnt.HANDLE writeEvent = Handleapi.INVALID_HANDLE_VALUE;

        HFileCleaner() {
        }

        @Override
        public void run() {
            if (this.readEvent.isNot_INVALID_HANDLE_VALUE()) {
                try {
                    Handleapi.CloseHandle((Winnt.HANDLE)this.readEvent);
                }
                catch (NativeErrorException nee) {
                    LOG.log(Level.SEVERE, "can't properly close readEvent " + nee.errno, nee);
                }
            }
            if (this.writeEvent.isNot_INVALID_HANDLE_VALUE()) {
                try {
                    Handleapi.CloseHandle((Winnt.HANDLE)this.writeEvent);
                }
                catch (NativeErrorException nee) {
                    LOG.log(Level.SEVERE, "can't properly close writeEvent " + nee.errno, nee);
                }
            }
            if (this.hFile.isNot_INVALID_HANDLE_VALUE()) {
                try {
                    Ioapiset.CancelIo((Winnt.HANDLE)this.hFile);
                }
                catch (NativeErrorException nee) {
                    LOG.log(Level.SEVERE, "can't Cancel IO on fd " + nee.errno, nee);
                }
                try {
                    Handleapi.CloseHandle((Winnt.HANDLE)this.hFile);
                }
                catch (NativeErrorException nee) {
                    LOG.log(Level.SEVERE, "can't properly close fd " + nee.errno, nee);
                }
            }
        }
    }
}

